/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.cmd.NeedsActiveTaskCmd;
import org.flowable.cmmn.engine.impl.task.TaskHelper;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.IdentityLinkUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class DeleteIdentityLinkCmd
extends NeedsActiveTaskCmd<Void> {
    private static final long serialVersionUID = 1L;
    public static final int IDENTITY_USER = 1;
    public static final int IDENTITY_GROUP = 2;
    protected String userId;
    protected String groupId;
    protected String type;

    public DeleteIdentityLinkCmd(String taskId, String userId, String groupId, String type) {
        super(taskId);
        this.validateParams(userId, groupId, type, taskId);
        this.taskId = taskId;
        this.userId = userId;
        this.groupId = groupId;
        this.type = type;
    }

    protected void validateParams(String userId, String groupId, String type, String taskId) {
        if (taskId == null) {
            throw new FlowableIllegalArgumentException("taskId is null");
        }
        if (type == null) {
            throw new FlowableIllegalArgumentException("type is required when adding a new task identity link");
        }
        if ("assignee".equals(type) || "owner".equals(type)) {
            if (groupId != null) {
                throw new FlowableIllegalArgumentException("Incompatible usage: cannot use type '" + type + "' together with a groupId");
            }
        } else if (userId == null && groupId == null) {
            throw new FlowableIllegalArgumentException("userId and groupId cannot both be null");
        }
    }

    @Override
    protected Void execute(CommandContext commandContext, TaskEntity task) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        if ("assignee".equals(this.type)) {
            TaskHelper.changeTaskAssignee(task, null, cmmnEngineConfiguration);
        } else if ("owner".equals(this.type)) {
            TaskHelper.changeTaskOwner(task, null, cmmnEngineConfiguration);
        } else {
            IdentityLinkUtil.deleteTaskIdentityLinks(task, this.userId, this.groupId, this.type, cmmnEngineConfiguration);
        }
        return null;
    }
}

