/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.Sentry;

public class PlanFragment
extends PlanItemDefinition {
    protected Case caze;
    protected Map<String, PlanItem> planItemMap = new LinkedHashMap<String, PlanItem>();
    protected List<Sentry> sentries = new ArrayList<Sentry>();

    public PlanItem findPlanItemInPlanFragmentOrDownwards(String planItemId) {
        for (PlanItem planItem : this.planItemMap.values()) {
            PlanItem p;
            if (planItem.getId().equals(planItemId)) {
                return planItem;
            }
            if (!(planItem.getPlanItemDefinition() instanceof PlanFragment) || (p = ((PlanFragment)planItem.getPlanItemDefinition()).findPlanItemInPlanFragmentOrDownwards(planItemId)) == null) continue;
            return p;
        }
        return null;
    }

    public PlanItem findPlanItemInPlanFragmentOrUpwards(String planItemId) {
        if (this.planItemMap.containsKey(planItemId)) {
            return this.planItemMap.get(planItemId);
        }
        PlanFragment parentPlanFragment = this.getParent();
        if (parentPlanFragment != null) {
            return parentPlanFragment.findPlanItemInPlanFragmentOrUpwards(planItemId);
        }
        return null;
    }

    public Sentry findSentry(String sentryId) {
        for (Sentry sentry : this.sentries) {
            if (!sentry.getId().equals(sentryId)) continue;
            return sentry;
        }
        PlanFragment parentPlanFragment = this.getParent();
        if (parentPlanFragment != null) {
            return parentPlanFragment.findSentry(sentryId);
        }
        return null;
    }

    public void addPlanItem(PlanItem planItem) {
        this.planItemMap.put(planItem.getId(), planItem);
    }

    public void addSentry(Sentry sentry) {
        this.sentries.add(sentry);
    }

    public Case getCase() {
        return this.caze;
    }

    public void setCase(Case caze) {
        this.caze = caze;
    }

    public List<PlanItem> getPlanItems() {
        return new ArrayList<PlanItem>(this.planItemMap.values());
    }

    public Map<String, PlanItem> getPlanItemMap() {
        return this.planItemMap;
    }

    public void setPlanItemMap(Map<String, PlanItem> planItemMap) {
        this.planItemMap = planItemMap;
    }

    public List<Sentry> getSentries() {
        return this.sentries;
    }

    public void setSentries(List<Sentry> sentries) {
        this.sentries = sentries;
    }
}

