/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.history.variable;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.cmmn.api.CmmnHistoryService;
import org.flowable.cmmn.api.history.HistoricVariableInstanceQuery;
import org.flowable.cmmn.rest.service.api.CmmnRestApiInterceptor;
import org.flowable.cmmn.rest.service.api.CmmnRestResponseFactory;
import org.flowable.cmmn.rest.service.api.engine.variable.QueryVariable;
import org.flowable.cmmn.rest.service.api.engine.variable.RestVariable;
import org.flowable.cmmn.rest.service.api.history.variable.HistoricVariableInstanceQueryRequest;
import org.flowable.cmmn.rest.service.api.history.variable.HistoricVariableInstanceResponse;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.api.query.QueryProperty;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.common.rest.api.PaginateListUtil;
import org.flowable.variable.api.history.HistoricVariableInstance;
import org.flowable.variable.service.impl.HistoricVariableInstanceQueryProperty;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.springframework.beans.factory.annotation.Autowired;

public class HistoricVariableInstanceBaseResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();
    @Autowired
    protected CmmnRestResponseFactory restResponseFactory;
    @Autowired
    protected CmmnHistoryService historyService;
    @Autowired(required=false)
    protected CmmnRestApiInterceptor restApiInterceptor;

    protected DataResponse<HistoricVariableInstanceResponse> getQueryResponse(HistoricVariableInstanceQueryRequest queryRequest, Map<String, String> allRequestParams) {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        if (Boolean.TRUE.equals(queryRequest.getExcludeTaskVariables())) {
            query.excludeTaskVariables();
        }
        if (Boolean.TRUE.equals(queryRequest.getExcludeLocalVariables())) {
            query.excludeLocalVariables();
        }
        if (queryRequest.getTaskId() != null) {
            query.taskId(queryRequest.getTaskId());
        }
        if (queryRequest.getPlanItemInstanceId() != null) {
            query.planItemInstanceId(queryRequest.getPlanItemInstanceId());
        }
        if (queryRequest.getCaseInstanceId() != null) {
            query.caseInstanceId(queryRequest.getCaseInstanceId());
        }
        if (queryRequest.getVariableName() != null) {
            query.variableName(queryRequest.getVariableName());
        }
        if (queryRequest.getVariableNameLike() != null) {
            query.variableNameLike(queryRequest.getVariableNameLike());
        }
        if (queryRequest.getVariables() != null) {
            this.addVariables(query, queryRequest.getVariables());
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessHistoryVariableInfoWithQuery(query, queryRequest);
        }
        return PaginateListUtil.paginateList(allRequestParams, (Query)query, (String)"variableName", allowedSortProperties, this.restResponseFactory::createHistoricVariableInstanceResponseList);
    }

    public RestVariable getVariableFromRequest(boolean includeBinary, String varInstanceId) {
        HistoricVariableInstance varObject = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().id(varInstanceId).singleResult();
        if (varObject == null) {
            throw new FlowableObjectNotFoundException("Historic variable instance '" + varInstanceId + "' couldn't be found.", VariableInstanceEntity.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessHistoryVariableInfoById(varObject);
        }
        return this.restResponseFactory.createRestVariable(varObject.getVariableName(), varObject.getValue(), null, varInstanceId, 7, includeBinary);
    }

    protected void addVariables(HistoricVariableInstanceQuery variableInstanceQuery, List<QueryVariable> variables) {
        block3: for (QueryVariable variable : variables) {
            if (variable.getVariableOperation() == null) {
                throw new FlowableIllegalArgumentException("Variable operation is missing for variable: " + variable.getName());
            }
            if (variable.getValue() == null) {
                throw new FlowableIllegalArgumentException("Variable value is missing for variable: " + variable.getName());
            }
            boolean nameLess = variable.getName() == null;
            Object actualValue = this.restResponseFactory.getVariableValue(variable);
            if (nameLess) {
                throw new FlowableIllegalArgumentException("Value-only query (without a variable-name) is not supported");
            }
            switch (variable.getVariableOperation()) {
                case EQUALS: {
                    variableInstanceQuery.variableValueEquals(variable.getName(), actualValue);
                    continue block3;
                }
            }
            throw new FlowableIllegalArgumentException("Unsupported variable query operation: " + variable.getVariableOperation());
        }
    }

    static {
        allowedSortProperties.put("caseInstanceId", (QueryProperty)HistoricVariableInstanceQueryProperty.SCOPE_ID);
        allowedSortProperties.put("variableName", (QueryProperty)HistoricVariableInstanceQueryProperty.VARIABLE_NAME);
    }
}

