/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.management;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Map;
import org.flowable.cmmn.api.CmmnManagementService;
import org.flowable.cmmn.rest.service.api.CmmnRestApiInterceptor;
import org.flowable.cmmn.rest.service.api.CmmnRestResponseFactory;
import org.flowable.cmmn.rest.service.api.management.HistoryJobQueryProperties;
import org.flowable.cmmn.rest.service.api.management.HistoryJobResponse;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.common.rest.api.PaginateListUtil;
import org.flowable.job.api.HistoryJobQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Jobs"}, description="Manage history Jobs", authorizations={@Authorization(value="basicAuth")})
public class HistoryJobCollectionResource {
    @Autowired
    protected CmmnRestResponseFactory restResponseFactory;
    @Autowired
    protected CmmnManagementService managementService;
    @Autowired(required=false)
    protected CmmnRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="List history jobs", tags={"Jobs"}, nickname="listDeadLetterJobs")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", dataType="string", value="Only return the job with the given id", paramType="query"), @ApiImplicitParam(name="withException", dataType="boolean", value="If true, only return jobs for which an exception occurred while executing it. If false, this parameter is ignored.", paramType="query"), @ApiImplicitParam(name="exceptionMessage", dataType="string", value="Only return jobs with the given exception message", paramType="query"), @ApiImplicitParam(name="scopeType", dataType="string", value="Only return jobs with the given scope type", paramType="query"), @ApiImplicitParam(name="tenantId", dataType="string", value="Only return jobs with the given tenantId.", paramType="query"), @ApiImplicitParam(name="tenantIdLike", dataType="string", value="Only return jobs with a tenantId like the given value.", paramType="query"), @ApiImplicitParam(name="withoutTenantId", dataType="boolean", value="If true, only returns jobs without a tenantId set. If false, the withoutTenantId parameter is ignored.", paramType="query"), @ApiImplicitParam(name="lockOwner", dataType="string", value="If true, only return jobs which are owned by the given lockOwner.", paramType="query"), @ApiImplicitParam(name="locked", dataType="boolean", value="If true, only return jobs which are locked.  If false, this parameter is ignored.", paramType="query"), @ApiImplicitParam(name="unlocked", dataType="boolean", value="If true, only return jobs which are unlocked. If false, this parameter is ignored.", paramType="query"), @ApiImplicitParam(name="sort", dataType="string", value="Property to sort on, to be used together with the order.", allowableValues="id,retries,tenantId", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the requested jobs were returned."), @ApiResponse(code=400, message="Indicates an illegal value has been used in a url query parameter. Status description contains additional details about the error.")})
    @GetMapping(value={"/cmmn-management/history-jobs"}, produces={"application/json"})
    public DataResponse<HistoryJobResponse> getHistoryJobs(@ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams) {
        HistoryJobQuery query = this.managementService.createHistoryJobQuery();
        if (allRequestParams.containsKey("id")) {
            query.jobId(allRequestParams.get("id"));
        }
        if (allRequestParams.containsKey("scopeType")) {
            query.jobId(allRequestParams.get("scopeType"));
        }
        if (allRequestParams.containsKey("withException") && Boolean.parseBoolean(allRequestParams.get("withException"))) {
            query.withException();
        }
        if (allRequestParams.containsKey("exceptionMessage")) {
            query.exceptionMessage(allRequestParams.get("exceptionMessage"));
        }
        if (allRequestParams.containsKey("lockOwner")) {
            query.lockOwner(allRequestParams.get("lockOwner"));
        }
        if (allRequestParams.containsKey("locked") && Boolean.parseBoolean(allRequestParams.get("locked"))) {
            query.locked();
        }
        if (allRequestParams.containsKey("unlocked") && Boolean.parseBoolean(allRequestParams.get("unlocked"))) {
            query.unlocked();
        }
        if (allRequestParams.containsKey("tenantId")) {
            query.jobTenantId(allRequestParams.get("tenantId"));
        }
        if (allRequestParams.containsKey("tenantIdLike")) {
            query.jobTenantIdLike(allRequestParams.get("tenantIdLike"));
        }
        if (allRequestParams.containsKey("withoutTenantId") && Boolean.parseBoolean(allRequestParams.get("withoutTenantId"))) {
            query.jobWithoutTenantId();
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessHistoryJobInfoWithQuery(query);
        }
        return PaginateListUtil.paginateList(allRequestParams, (Query)query, (String)"id", HistoryJobQueryProperties.PROPERTIES, this.restResponseFactory::createHistoryJobResponseList);
    }
}

