/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.rest.service.api.repository.BaseCaseDefinitionResource;
import org.flowable.cmmn.rest.service.api.repository.DecisionResponse;
import org.flowable.dmn.api.DmnDecision;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Case Definitions"}, description="Manage Case Definitions", authorizations={@Authorization(value="basicAuth")})
public class CaseDefinitionDecisionCollectionResource
extends BaseCaseDefinitionResource {
    @ApiOperation(value="List decisions for a case definition", nickname="listCaseDefinitionDecisions", tags={"Case Definitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the case definition was found and the decisions are returned.", response=DmnDecision.class, responseContainer="List"), @ApiResponse(code=404, message="Indicates the requested case definition was not found.")})
    @GetMapping(value={"/cmmn-repository/case-definitions/{caseDefinitionId}/decisions"}, produces={"application/json"})
    public List<DecisionResponse> getDecisionsForCaseDefinition(@ApiParam(name="caseDefinitionId") @PathVariable String caseDefinitionId) {
        CaseDefinition caseDefinition = this.getCaseDefinitionFromRequest(caseDefinitionId);
        List decisions = this.repositoryService.getDecisionsForCaseDefinition(caseDefinition.getId());
        return this.restResponseFactory.createDecisionResponseList(decisions, caseDefinitionId);
    }

    @Deprecated
    @ApiOperation(value="List decision tables for a case definition", nickname="listCaseDefinitionDecisionTables", tags={"Case Definitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the case definition was found and the decision tables are returned.", response=DmnDecision.class, responseContainer="List"), @ApiResponse(code=404, message="Indicates the requested case definition was not found.")})
    @GetMapping(value={"/cmmn-repository/case-definitions/{caseDefinitionId}/decision-tables"}, produces={"application/json"})
    public List<DecisionResponse> getDecisionTablesForCaseDefinition(@ApiParam(name="caseDefinitionId") @PathVariable String caseDefinitionId) {
        return this.getDecisionsForCaseDefinition(caseDefinitionId);
    }
}

