/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.runtime.planitem;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import jakarta.servlet.http.HttpServletResponse;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.rest.service.api.RestActionRequest;
import org.flowable.cmmn.rest.service.api.runtime.planitem.PlanItemInstanceBaseResource;
import org.flowable.cmmn.rest.service.api.runtime.planitem.PlanItemInstanceResponse;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Plan Item Instances"}, description="Manage Plan Item Instances", authorizations={@Authorization(value="basicAuth")})
public class PlanItemInstanceResource
extends PlanItemInstanceBaseResource {
    @ApiOperation(value="Get an plan item instance", tags={"Plan Item Instances"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the plan item instance was found and returned."), @ApiResponse(code=404, message="Indicates the plan item instance was not found.")})
    @GetMapping(value={"/cmmn-runtime/plan-item-instances/{planItemInstanceId}"}, produces={"application/json"})
    public PlanItemInstanceResponse getPlanItemInstance(@ApiParam(name="planItemInstanceId") @PathVariable String planItemInstanceId) {
        return this.restResponseFactory.createPlanItemInstanceResponse(this.getPlanItemInstanceFromRequest(planItemInstanceId));
    }

    @ApiOperation(value="Execute an action on a plan item instance", tags={"Plan Item Instances"}, notes="")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the plan item instance was found and the action is performed."), @ApiResponse(code=204, message="Indicates the plan item instance was found, the action was performed and the action caused the plan item instance to end."), @ApiResponse(code=400, message="Indicates an illegal action was requested, required parameters are missing in the request body or illegal variables are passed in. Status description contains additional information about the error."), @ApiResponse(code=404, message="Indicates the plan item instance was not found.")})
    @PutMapping(value={"/cmmn-runtime/plan-item-instances/{planItemInstanceId}"}, produces={"application/json"})
    public PlanItemInstanceResponse performPlanItemInstanceAction(@ApiParam(name="planItemInstanceId") @PathVariable String planItemInstanceId, @RequestBody RestActionRequest actionRequest, HttpServletResponse response) {
        PlanItemInstance planItemInstance = this.getPlanItemInstanceFromRequest(planItemInstanceId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.doPlanItemInstanceAction(planItemInstance, actionRequest);
        }
        if ("trigger".equals(actionRequest.getAction())) {
            this.runtimeService.triggerPlanItemInstance(planItemInstance.getId());
        } else if ("enable".equals(actionRequest.getAction())) {
            this.runtimeService.startPlanItemInstance(planItemInstanceId);
        } else if ("disable".equals(actionRequest.getAction())) {
            this.runtimeService.disablePlanItemInstance(planItemInstanceId);
        } else if ("start".equals(actionRequest.getAction())) {
            this.runtimeService.startPlanItemInstance(planItemInstanceId);
        } else {
            throw new FlowableIllegalArgumentException("Invalid action: '" + actionRequest.getAction() + "'.");
        }
        planItemInstance = (PlanItemInstance)this.runtimeService.createPlanItemInstanceQuery().planItemInstanceId(planItemInstance.getId()).singleResult();
        if (planItemInstance == null) {
            response.setStatus(HttpStatus.NO_CONTENT.value());
            return null;
        }
        return this.restResponseFactory.createPlanItemInstanceResponse(planItemInstance);
    }
}

