/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.db;

import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.db.EngineDatabaseConfiguration;
import org.flowable.common.engine.impl.db.LiquibaseBasedSchemaManager;
import org.flowable.common.engine.impl.db.LiquibaseDatabaseConfiguration;
import org.flowable.common.engine.impl.db.SchemaManager;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;

public class DmnDbSchemaManager
extends LiquibaseBasedSchemaManager {
    public static final String LIQUIBASE_CHANGELOG = "org/flowable/dmn/db/liquibase/flowable-dmn-db-changelog.xml";

    public DmnDbSchemaManager() {
        super("dmn", LIQUIBASE_CHANGELOG, "ACT_DMN_");
    }

    protected LiquibaseDatabaseConfiguration getDatabaseConfiguration() {
        return new EngineDatabaseConfiguration((AbstractEngineConfiguration)CommandContextUtil.getDmnEngineConfiguration());
    }

    public void initSchema() {
        this.initSchema(CommandContextUtil.getDmnEngineConfiguration().getDatabaseSchemaUpdate());
    }

    public void schemaCreate() {
        this.getCommonSchemaManager().schemaCreate();
        super.schemaCreate();
    }

    public void schemaDrop() {
        try {
            super.schemaDrop();
        }
        catch (Exception e) {
            this.logger.info("Error dropping dmn engine tables", (Throwable)e);
        }
        try {
            this.getCommonSchemaManager().schemaDrop();
        }
        catch (Exception e) {
            this.logger.info("Error dropping common tables", (Throwable)e);
        }
    }

    public String schemaUpdate() {
        this.getCommonSchemaManager().schemaUpdate();
        return super.schemaUpdate();
    }

    protected SchemaManager getCommonSchemaManager() {
        return CommandContextUtil.getDmnEngineConfiguration().getCommonSchemaManager();
    }
}

