/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.hitpolicy;

import java.util.ArrayList;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.dmn.api.RuleExecutionAuditContainer;
import org.flowable.dmn.engine.impl.el.ELExecutionContext;
import org.flowable.dmn.engine.impl.hitpolicy.AbstractHitPolicy;
import org.flowable.dmn.engine.impl.hitpolicy.ComposeDecisionResultBehavior;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.flowable.dmn.model.HitPolicy;

public class HitPolicyAny
extends AbstractHitPolicy
implements ComposeDecisionResultBehavior {
    @Override
    public String getHitPolicyName() {
        return HitPolicy.ANY.getValue();
    }

    @Override
    public void composeDecisionResults(ELExecutionContext executionContext) {
        boolean validationFailed = false;
        for (Map.Entry<Integer, Map<String, Object>> ruleResults : executionContext.getRuleResults().entrySet()) {
            block1: for (Map.Entry<Integer, Map<String, Object>> otherRuleResults : executionContext.getRuleResults().entrySet()) {
                if (otherRuleResults.getKey().equals(ruleResults.getKey())) continue;
                for (Map.Entry<String, Object> outputValues : otherRuleResults.getValue().entrySet()) {
                    if (ruleResults.getValue().containsKey(outputValues.getKey()) && (!ruleResults.getValue().containsKey(outputValues.getKey()) || outputValues.getValue().equals(ruleResults.getValue().get(outputValues.getKey())))) continue;
                    String hitPolicyViolatedMessage = String.format("HitPolicy %s violated; both rule %d and %d are valid but output %s has different values.", this.getHitPolicyName(), otherRuleResults.getKey(), ruleResults.getKey(), outputValues.getKey());
                    if (CommandContextUtil.getDmnEngineConfiguration().isStrictMode()) {
                        ((RuleExecutionAuditContainer)executionContext.getAuditContainer().getRuleExecutions().get(otherRuleResults.getKey())).setExceptionMessage(hitPolicyViolatedMessage);
                        ((RuleExecutionAuditContainer)executionContext.getAuditContainer().getRuleExecutions().get(ruleResults.getKey())).setExceptionMessage(hitPolicyViolatedMessage);
                        throw new FlowableException(String.format("HitPolicy %s violated.", this.getHitPolicyName()));
                    }
                    validationFailed = true;
                    ((RuleExecutionAuditContainer)executionContext.getAuditContainer().getRuleExecutions().get(otherRuleResults.getKey())).setValidationMessage(hitPolicyViolatedMessage);
                    ((RuleExecutionAuditContainer)executionContext.getAuditContainer().getRuleExecutions().get(ruleResults.getKey())).setValidationMessage(hitPolicyViolatedMessage);
                    continue block1;
                }
            }
        }
        ArrayList<Map<String, Object>> ruleResults = new ArrayList<Map<String, Object>>(executionContext.getRuleResults().values());
        if (!ruleResults.isEmpty()) {
            if (!CommandContextUtil.getDmnEngineConfiguration().isStrictMode() && validationFailed) {
                executionContext.getAuditContainer().setValidationMessage(String.format("HitPolicy %s violated; multiple valid rules with different outcomes. Setting last valid rule result as final result.", this.getHitPolicyName()));
            }
            executionContext.getAuditContainer().addDecisionResultObject((Map)ruleResults.get(ruleResults.size() - 1));
        }
    }
}

