/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.db;

import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.flowable.dmn.engine.DmnEngine;
import org.flowable.dmn.engine.DmnEngines;

public class DbSchemaDrop {
    public static void main(String[] args) {
        try {
            DmnEngine dmnEngine = DmnEngines.getDefaultDmnEngine();
            DataSource dataSource = dmnEngine.getDmnEngineConfiguration().getDataSource();
            JdbcConnection connection = new JdbcConnection(dataSource.getConnection());
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
            database.setDatabaseChangeLogTableName("ACT_DMN_" + database.getDatabaseChangeLogTableName());
            database.setDatabaseChangeLogLockTableName("ACT_DMN_" + database.getDatabaseChangeLogLockTableName());
            if (StringUtils.isNotEmpty((CharSequence)dmnEngine.getDmnEngineConfiguration().getDatabaseSchema())) {
                database.setDefaultSchemaName(dmnEngine.getDmnEngineConfiguration().getDatabaseSchema());
                database.setLiquibaseSchemaName(dmnEngine.getDmnEngineConfiguration().getDatabaseSchema());
            }
            if (StringUtils.isNotEmpty((CharSequence)dmnEngine.getDmnEngineConfiguration().getDatabaseCatalog())) {
                database.setDefaultCatalogName(dmnEngine.getDmnEngineConfiguration().getDatabaseCatalog());
                database.setLiquibaseCatalogName(dmnEngine.getDmnEngineConfiguration().getDatabaseCatalog());
            }
            Liquibase liquibase = new Liquibase("org/flowable/dmn/db/liquibase/flowable-dmn-db-changelog.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            liquibase.dropAll();
            liquibase.getDatabase().close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

