/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.tenant;

import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.tenant.ChangeTenantIdBuilder;
import org.flowable.common.engine.api.tenant.ChangeTenantIdResult;
import org.flowable.common.engine.impl.tenant.ChangeTenantIdManager;

public class ChangeTenantIdBuilderImpl
implements ChangeTenantIdBuilder {
    protected final String sourceTenantId;
    protected final String targetTenantId;
    protected final ChangeTenantIdManager changeTenantIdManager;
    protected String definitionTenantId;

    public ChangeTenantIdBuilderImpl(String sourceTenantId, String targetTenantId, ChangeTenantIdManager changeTenantIdManager) {
        if (sourceTenantId == null) {
            throw new FlowableIllegalArgumentException("The source tenant id must not be null.");
        }
        if (targetTenantId == null) {
            throw new FlowableIllegalArgumentException("The target tenant id must not be null.");
        }
        this.sourceTenantId = sourceTenantId;
        this.targetTenantId = targetTenantId;
        if (sourceTenantId.equals(targetTenantId)) {
            throw new FlowableIllegalArgumentException("The source and the target tenant ids must be different.");
        }
        this.changeTenantIdManager = changeTenantIdManager;
    }

    public ChangeTenantIdBuilder definitionTenantId(String definitionTenantId) {
        if (definitionTenantId == null) {
            throw new FlowableIllegalArgumentException("definitionTenantId must not be null");
        }
        this.definitionTenantId = definitionTenantId;
        return this;
    }

    public ChangeTenantIdResult simulate() {
        return this.changeTenantIdManager.simulate(this);
    }

    public ChangeTenantIdResult complete() {
        return this.changeTenantIdManager.complete(this);
    }

    public String getSourceTenantId() {
        return this.sourceTenantId;
    }

    public String getTargetTenantId() {
        return this.targetTenantId;
    }

    public String getDefinitionTenantId() {
        return this.definitionTenantId;
    }
}

