/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.flowable.common.engine.impl.cfg.IdGenerator;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.db.DbSqlSession;
import org.flowable.common.engine.impl.db.SingleCachedEntityMatcher;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.cache.CachedEntity;
import org.flowable.common.engine.impl.persistence.cache.CachedEntityMatcher;
import org.flowable.common.engine.impl.persistence.cache.EntityCache;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.common.engine.impl.util.CollectionUtil;

public abstract class AbstractDataManager<EntityImpl extends Entity>
implements DataManager<EntityImpl> {
    public static final int MAX_ENTRIES_IN_CLAUSE = 1000;

    public abstract Class<? extends EntityImpl> getManagedEntityClass();

    public List<Class<? extends EntityImpl>> getManagedEntitySubClasses() {
        return null;
    }

    protected CommandContext getCommandContext() {
        return Context.getCommandContext();
    }

    protected <T> T getSession(Class<T> sessionClass) {
        return this.getCommandContext().getSession(sessionClass);
    }

    protected DbSqlSession getDbSqlSession() {
        return this.getSession(DbSqlSession.class);
    }

    protected EntityCache getEntityCache() {
        return this.getSession(EntityCache.class);
    }

    @Override
    public EntityImpl findById(String entityId) {
        if (entityId == null) {
            return null;
        }
        Entity cachedEntity = (Entity)this.getEntityCache().findInCache(this.getManagedEntityClass(), entityId);
        if (cachedEntity != null) {
            return (EntityImpl)cachedEntity;
        }
        return this.getDbSqlSession().selectById(this.getManagedEntityClass(), entityId, false);
    }

    @Override
    public void insert(EntityImpl entity) {
        this.getDbSqlSession().insert((Entity)entity, this.getIdGenerator());
    }

    @Override
    public EntityImpl update(EntityImpl entity) {
        this.getDbSqlSession().update((Entity)entity);
        return entity;
    }

    @Override
    public void delete(String id) {
        EntityImpl entity = this.findById(id);
        this.delete(entity);
    }

    @Override
    public void delete(EntityImpl entity) {
        this.getDbSqlSession().delete((Entity)entity);
    }

    protected EntityImpl findByQuery(String selectQuery, Object parameter) {
        return (EntityImpl)((Entity)this.getDbSqlSession().selectOne(selectQuery, parameter));
    }

    protected List<EntityImpl> getList(String dbQueryName, Object parameter) {
        List result = this.getDbSqlSession().selectList(dbQueryName, parameter);
        return new ArrayList(result);
    }

    protected EntityImpl getEntity(String selectQuery, Object parameter, SingleCachedEntityMatcher<EntityImpl> cachedEntityMatcher, boolean checkDatabase) {
        for (Entity cachedEntity : this.getEntityCache().findInCache(this.getManagedEntityClass())) {
            if (!cachedEntityMatcher.isRetained(cachedEntity, parameter)) continue;
            return (EntityImpl)cachedEntity;
        }
        if (checkDatabase) {
            return (EntityImpl)((Entity)this.getDbSqlSession().selectOne(selectQuery, parameter));
        }
        return null;
    }

    protected List<EntityImpl> getList(String dbQueryName, Object parameter, CachedEntityMatcher<EntityImpl> cachedEntityMatcher) {
        return this.getList(dbQueryName, parameter, cachedEntityMatcher, true);
    }

    protected List<EntityImpl> getList(String dbQueryName, Object parameter, CachedEntityMatcher<EntityImpl> cachedEntityMatcher, boolean checkCache) {
        return this.getList(this.getDbSqlSession(), dbQueryName, parameter, cachedEntityMatcher, checkCache);
    }

    protected List<EntityImpl> getList(DbSqlSession dbSqlSession, String dbQueryName, Object parameter, CachedEntityMatcher<EntityImpl> cachedEntityMatcher, boolean checkCache) {
        return this.getList(dbSqlSession, dbQueryName, parameter, cachedEntityMatcher, checkCache, false);
    }

    protected List<EntityImpl> getList(DbSqlSession dbSqlSession, String dbQueryName, Object parameter, CachedEntityMatcher<EntityImpl> cachedEntityMatcher, boolean checkCache, boolean includeDeleted) {
        Collection<CachedEntity> cachedObjects;
        Collection<Object> result = dbSqlSession.selectList(dbQueryName, parameter);
        if (checkCache && ((cachedObjects = this.getEntityCache().findInCacheAsCachedObjects(this.getManagedEntityClass())) != null && cachedObjects.size() > 0 || this.getManagedEntitySubClasses() != null)) {
            HashMap<String, Entity> entityMap = new HashMap<String, Entity>(result.size());
            for (Entity entity : result) {
                entityMap.put(entity.getId(), entity);
            }
            if (cachedObjects != null && cachedEntityMatcher != null) {
                for (CachedEntity cachedEntity : cachedObjects) {
                    Entity cachedEntity2 = cachedEntity.getEntity();
                    if (!cachedEntityMatcher.isRetained(result, cachedObjects, cachedEntity2, parameter)) continue;
                    entityMap.put(cachedEntity2.getId(), cachedEntity2);
                }
            }
            if (this.getManagedEntitySubClasses() != null && cachedEntityMatcher != null) {
                for (Class clazz : this.getManagedEntitySubClasses()) {
                    Collection<CachedEntity> subclassCachedObjects = this.getEntityCache().findInCacheAsCachedObjects(clazz);
                    if (subclassCachedObjects == null) continue;
                    for (CachedEntity subclassCachedObject : subclassCachedObjects) {
                        Entity cachedSubclassEntity = subclassCachedObject.getEntity();
                        if (!cachedEntityMatcher.isRetained(result, cachedObjects, cachedSubclassEntity, parameter)) continue;
                        entityMap.put(cachedSubclassEntity.getId(), cachedSubclassEntity);
                    }
                }
            }
            result = entityMap.values();
        }
        if (!includeDeleted && result.size() > 0) {
            Iterator resultIterator = result.iterator();
            while (resultIterator.hasNext()) {
                if (!dbSqlSession.isEntityToBeDeleted((Entity)resultIterator.next())) continue;
                resultIterator.remove();
            }
        }
        return new ArrayList(result);
    }

    protected List<EntityImpl> getListFromCache(CachedEntityMatcher<EntityImpl> entityMatcher, Object parameter) {
        return this.getListFromCache(entityMatcher, parameter, false);
    }

    protected List<EntityImpl> getListFromCache(CachedEntityMatcher<EntityImpl> entityMatcher, Object parameter, boolean includeDeletedEntities) {
        Collection<CachedEntity> cachedObjects = this.getEntityCache().findInCacheAsCachedObjects(this.getManagedEntityClass());
        DbSqlSession dbSqlSession = this.getDbSqlSession();
        ArrayList<Entity> result = new ArrayList<Entity>(cachedObjects != null ? cachedObjects.size() : 1);
        if (cachedObjects != null && entityMatcher != null) {
            for (CachedEntity cachedEntity : cachedObjects) {
                Entity cachedEntity2 = cachedEntity.getEntity();
                if (!entityMatcher.isRetained(null, cachedObjects, cachedEntity2, parameter) || !includeDeletedEntities && dbSqlSession.isEntityToBeDeleted(cachedEntity2)) continue;
                result.add(cachedEntity2);
            }
        }
        if (this.getManagedEntitySubClasses() != null && entityMatcher != null) {
            for (Class clazz : this.getManagedEntitySubClasses()) {
                Collection<CachedEntity> subclassCachedObjects = this.getEntityCache().findInCacheAsCachedObjects(clazz);
                if (subclassCachedObjects == null) continue;
                for (CachedEntity subclassCachedObject : subclassCachedObjects) {
                    Entity cachedSubclassEntity = subclassCachedObject.getEntity();
                    if (!entityMatcher.isRetained(null, cachedObjects, cachedSubclassEntity, parameter) || dbSqlSession.isEntityToBeDeleted(cachedSubclassEntity)) continue;
                    result.add(cachedSubclassEntity);
                }
            }
        }
        return result;
    }

    public void bulkDelete(String statement, CachedEntityMatcher<EntityImpl> cachedEntityMatcher, Object parameter) {
        DbSqlSession dbSqlSession = this.getDbSqlSession();
        dbSqlSession.delete(statement, parameter, this.getManagedEntityClass());
        this.deleteCachedEntities(dbSqlSession, cachedEntityMatcher, parameter);
    }

    protected void deleteCachedEntities(DbSqlSession dbSqlSession, CachedEntityMatcher<EntityImpl> cachedEntityMatcher, Object parameter) {
        this.deleteCachedEntities(dbSqlSession, this.getEntityCache().findInCacheAsCachedObjects(this.getManagedEntityClass()), cachedEntityMatcher, parameter);
        if (this.getManagedEntitySubClasses() != null && cachedEntityMatcher != null) {
            for (Class<EntityImpl> entitySubClass : this.getManagedEntitySubClasses()) {
                this.deleteCachedEntities(dbSqlSession, this.getEntityCache().findInCacheAsCachedObjects(entitySubClass), cachedEntityMatcher, parameter);
            }
        }
    }

    protected void deleteCachedEntities(DbSqlSession dbSqlSession, Collection<CachedEntity> cachedObjects, CachedEntityMatcher<EntityImpl> cachedEntityMatcher, Object parameter) {
        if (cachedObjects != null && cachedEntityMatcher != null) {
            for (CachedEntity cachedObject : cachedObjects) {
                Entity cachedEntity = cachedObject.getEntity();
                boolean entityMatches = cachedEntityMatcher.isRetained(null, cachedObjects, cachedEntity, parameter);
                if (cachedEntity.isInserted() && entityMatches) {
                    dbSqlSession.delete(cachedEntity);
                }
                if (!entityMatches) continue;
                cachedEntity.setDeleted(true);
            }
        }
    }

    protected List<List<String>> createSafeInValuesList(Collection<String> values) {
        return CollectionUtil.partition(values, 1000);
    }

    protected void executeChangeWithInClause(List<EntityImpl> entities, Consumer<List<EntityImpl>> consumer) {
        CollectionUtil.consumePartitions(entities, 1000, consumer);
    }

    protected void bulkDeleteEntities(String statement, List<EntityImpl> entities) {
        this.executeChangeWithInClause(entities, entitiesParameter -> this.getDbSqlSession().delete(statement, entitiesParameter, this.getManagedEntityClass()));
    }

    protected void bulkUpdateEntities(String statement, Map<String, Object> parameters, String collectionNameInSqlStatement, List<EntityImpl> entities) {
        this.executeChangeWithInClause(entities, entitiesParameter -> {
            HashMap<String, List> copyParameters = new HashMap<String, List>(parameters);
            copyParameters.put(collectionNameInSqlStatement, (List)entitiesParameter);
            this.getDbSqlSession().update(statement, copyParameters);
        });
    }

    protected boolean isEntityInserted(DbSqlSession dbSqlSession, String entityLogicalName, String entityId) {
        Class<?> executionEntityClass = dbSqlSession.getDbSqlSessionFactory().getLogicalNameToClassMapping().get(entityLogicalName);
        return executionEntityClass != null && dbSqlSession.isEntityInserted(executionEntityClass, entityId);
    }

    protected abstract IdGenerator getIdGenerator();
}

