/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.flowable.eventregistry.model.InboundChannelModel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class KafkaInboundChannelModel
extends InboundChannelModel {
    protected String groupId;
    protected Collection<String> topics;
    protected String topicPattern;
    protected Collection<TopicPartition> topicPartitions;
    protected String clientIdPrefix;
    protected String concurrency;
    protected RetryConfiguration retry;
    protected List<CustomProperty> customProperties;
    protected String partitionOutputName;
    protected String offsetOutputName;
    protected String topicOutputName;

    public KafkaInboundChannelModel() {
        this.setType("kafka");
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public Collection<String> getTopics() {
        return this.topics;
    }

    public void setTopics(Collection<String> topics) {
        this.topics = topics;
    }

    public String getTopicPattern() {
        return this.topicPattern;
    }

    public void setTopicPattern(String topicPattern) {
        this.topicPattern = topicPattern;
    }

    public Collection<TopicPartition> getTopicPartitions() {
        return this.topicPartitions;
    }

    public void setTopicPartitions(Collection<TopicPartition> topicPartitions) {
        this.topicPartitions = topicPartitions;
    }

    public String getClientIdPrefix() {
        return this.clientIdPrefix;
    }

    public void setClientIdPrefix(String clientIdPrefix) {
        this.clientIdPrefix = clientIdPrefix;
    }

    public String getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(String concurrency) {
        this.concurrency = concurrency;
    }

    public RetryConfiguration getRetry() {
        return this.retry;
    }

    public void setRetry(RetryConfiguration retry) {
        this.retry = retry;
    }

    public List<CustomProperty> getCustomProperties() {
        return this.customProperties;
    }

    public void addCustomProperty(String name, String value) {
        if (this.customProperties == null) {
            this.customProperties = new ArrayList<CustomProperty>();
        }
        this.customProperties.add(new CustomProperty(name, value));
    }

    public void setCustomProperties(List<CustomProperty> properties) {
        this.customProperties = properties;
    }

    public String getPartitionOutputName() {
        return this.partitionOutputName;
    }

    public void setPartitionOutputName(String partitionOutputName) {
        this.partitionOutputName = partitionOutputName;
    }

    public String getOffsetOutputName() {
        return this.offsetOutputName;
    }

    public void setOffsetOutputName(String offsetOutputName) {
        this.offsetOutputName = offsetOutputName;
    }

    public String getTopicOutputName() {
        return this.topicOutputName;
    }

    public void setTopicOutputName(String topicOutputName) {
        this.topicOutputName = topicOutputName;
    }

    public static class TopicPartition {
        protected String topic;
        protected Collection<String> partitions;

        public String getTopic() {
            return this.topic;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public Collection<String> getPartitions() {
            return this.partitions;
        }

        public void setPartitions(Collection<String> partitions) {
            this.partitions = partitions;
        }
    }

    public static class NonBlockingRetryBackOff {
        protected String delay;
        protected String maxDelay;
        protected String multiplier;
        protected String random;

        public String getDelay() {
            return this.delay;
        }

        public void setDelay(String delay) {
            this.delay = delay;
        }

        public String getMaxDelay() {
            return this.maxDelay;
        }

        public void setMaxDelay(String maxDelay) {
            this.maxDelay = maxDelay;
        }

        public String getMultiplier() {
            return this.multiplier;
        }

        public void setMultiplier(String multiplier) {
            this.multiplier = multiplier;
        }

        public String getRandom() {
            return this.random;
        }

        public void setRandom(String random) {
            this.random = random;
        }
    }

    public static class RetryConfiguration {
        protected String attempts;
        protected String dltTopicSuffix;
        protected String retryTopicSuffix;
        protected String fixedDelayTopicStrategy;
        protected String topicSuffixingStrategy;
        protected NonBlockingRetryBackOff nonBlockingBackOff;
        protected String autoCreateTopics;
        protected String numPartitions;
        protected String replicationFactor;

        public String getAttempts() {
            return this.attempts;
        }

        public void setAttempts(String attempts) {
            this.attempts = attempts;
        }

        public String getDltTopicSuffix() {
            return this.dltTopicSuffix;
        }

        public void setDltTopicSuffix(String dltTopicSuffix) {
            this.dltTopicSuffix = dltTopicSuffix;
        }

        public String getRetryTopicSuffix() {
            return this.retryTopicSuffix;
        }

        public void setRetryTopicSuffix(String retryTopicSuffix) {
            this.retryTopicSuffix = retryTopicSuffix;
        }

        public String getFixedDelayTopicStrategy() {
            return this.fixedDelayTopicStrategy;
        }

        public void setFixedDelayTopicStrategy(String fixedDelayTopicStrategy) {
            this.fixedDelayTopicStrategy = fixedDelayTopicStrategy;
        }

        public String getTopicSuffixingStrategy() {
            return this.topicSuffixingStrategy;
        }

        public void setTopicSuffixingStrategy(String topicSuffixingStrategy) {
            this.topicSuffixingStrategy = topicSuffixingStrategy;
        }

        public NonBlockingRetryBackOff getNonBlockingBackOff() {
            return this.nonBlockingBackOff;
        }

        public void setNonBlockingBackOff(NonBlockingRetryBackOff nonBlockingBackOff) {
            this.nonBlockingBackOff = nonBlockingBackOff;
        }

        public String getAutoCreateTopics() {
            return this.autoCreateTopics;
        }

        public void setAutoCreateTopics(String autoCreateTopics) {
            this.autoCreateTopics = autoCreateTopics;
        }

        public String getNumPartitions() {
            return this.numPartitions;
        }

        public void setNumPartitions(String numPartitions) {
            this.numPartitions = numPartitions;
        }

        public String getReplicationFactor() {
            return this.replicationFactor;
        }

        public void setReplicationFactor(String replicationFactor) {
            this.replicationFactor = replicationFactor;
        }
    }

    public static class CustomProperty {
        protected String name;
        protected String value;

        public CustomProperty() {
        }

        public CustomProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

