/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.external.job.rest.service.api.acquire;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableForbiddenException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.external.job.rest.service.api.ExternalJobRestResponseFactory;
import org.flowable.external.job.rest.service.api.ExternalWorkerJobBaseResource;
import org.flowable.external.job.rest.service.api.acquire.UnacquireExternalWorkerJobsRequest;
import org.flowable.job.api.ExternalWorkerJob;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Unacquire"})
public class ExternalWorkerUnacquireJobResource
extends ExternalWorkerJobBaseResource {
    protected final ExternalJobRestResponseFactory restResponseFactory;

    public ExternalWorkerUnacquireJobResource(ExternalJobRestResponseFactory restResponseFactory) {
        this.restResponseFactory = restResponseFactory;
    }

    @ApiOperation(value="Unacquire External Worker Jobs", tags={"Unacquire"})
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the jobs were unacquired."), @ApiResponse(code=400, message="Indicates the request was invalid."), @ApiResponse(code=403, message="Indicates the user does not have the rights to unacquire the jobs.")})
    @PostMapping(value={"/unacquire/jobs"}, produces={"application/json"})
    public ResponseEntity<?> unacquireJobs(@RequestBody UnacquireExternalWorkerJobsRequest request) {
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessUnacquireExternalWorkerJobs(request);
        }
        if (StringUtils.isEmpty((CharSequence)request.getWorkerId())) {
            throw new FlowableIllegalArgumentException("worker id is required");
        }
        this.unaquireExternalWorkerJobs(request.getWorkerId(), request.getTenantId());
        return ResponseEntity.noContent().build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiOperation(value="Unaquire an External Worker Job", code=204, tags={"Unacquire"})
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the job was successfully unaquired."), @ApiResponse(code=400, message="Indicates the request was invalid."), @ApiResponse(code=403, message="Indicates the user does not have the rights to unacquire the job."), @ApiResponse(code=404, message="Indicates the job does not exist.")})
    @PostMapping(value={"/unacquire/jobs/{jobId}"}, produces={"application/json"})
    public ResponseEntity<?> unaquireJob(@PathVariable String jobId, @RequestBody UnacquireExternalWorkerJobsRequest request) {
        String workerId = request.getWorkerId();
        if (StringUtils.isEmpty((CharSequence)workerId)) {
            throw new FlowableIllegalArgumentException("worker id is required");
        }
        ExternalWorkerJob job = this.getExternalWorkerJobById(jobId);
        if (!workerId.equals(job.getLockOwner())) {
            throw new FlowableForbiddenException(workerId + " does not hold a lock on the requested job");
        }
        if (job.getProcessInstanceId() != null) {
            if (this.managementService == null) throw new FlowableException("Cannot unacquire BPMN job. There is no BPMN engine available");
            if (this.restApiInterceptor != null) {
                this.restApiInterceptor.unacquireExternalWorkerJob(job, request);
            }
            this.managementService.unacquireExternalWorkerJob(jobId, workerId);
            return ResponseEntity.noContent().build();
        } else {
            if (!"cmmn".equals(job.getScopeType())) throw new FlowableIllegalArgumentException("Can only unacquire BPMN or CMMN external job. Job with id '" + jobId + "' is from scope '" + job.getScopeType() + "'");
            if (this.cmmnManagementService == null) throw new FlowableException("Cannot unacquire CMMN job. There is no CMMN engine available");
            if (this.restApiInterceptor != null) {
                this.restApiInterceptor.unacquireExternalWorkerJob(job, request);
            }
            this.cmmnManagementService.unacquireExternalWorkerJob(jobId, workerId);
        }
        return ResponseEntity.noContent().build();
    }

    protected void unaquireExternalWorkerJobs(String workerId, String tenantId) {
        if (this.managementService != null) {
            if (StringUtils.isNotEmpty((CharSequence)tenantId)) {
                this.managementService.unacquireAllExternalWorkerJobsForWorker(workerId, tenantId);
            } else {
                this.managementService.unacquireAllExternalWorkerJobsForWorker(workerId);
            }
        } else if (this.cmmnManagementService != null) {
            if (StringUtils.isNotEmpty((CharSequence)tenantId)) {
                this.cmmnManagementService.unacquireAllExternalWorkerJobsForWorker(workerId, tenantId);
            } else {
                this.cmmnManagementService.unacquireAllExternalWorkerJobsForWorker(workerId);
            }
        } else {
            throw new FlowableException("Cannot unacquire external jobs. There is no BPMN or CMMN engine available");
        }
    }
}

