/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.history.async.util;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.job.service.impl.history.async.AsyncHistoryDateUtil;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class AsyncHistoryJsonUtil {
    public static void putIfNotNull(Map<String, String> map, String key, String value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    public static void putIfNotNull(Map<String, String> map, String key, int value) {
        map.put(key, Integer.toString(value));
    }

    public static void putIfNotNull(Map<String, String> map, String key, Double value) {
        if (value != null) {
            map.put(key, Double.toString(value));
        }
    }

    public static void putIfNotNull(Map<String, String> map, String key, Long value) {
        if (value != null) {
            map.put(key, Long.toString(value));
        }
    }

    public static void putIfNotNull(Map<String, String> map, String key, Date value) {
        if (value != null) {
            map.put(key, AsyncHistoryDateUtil.formatDate(value));
        }
    }

    public static void putIfNotNull(Map<String, String> map, String key, Boolean value) {
        if (value != null) {
            map.put(key, Boolean.toString(value));
        }
    }

    public static String convertToBase64(VariableInstanceEntity variable) {
        byte[] bytes = variable.getBytes();
        if (bytes != null) {
            return new String(Base64.getEncoder().encode(variable.getBytes()), StandardCharsets.US_ASCII);
        }
        return null;
    }

    public static String getStringFromJson(ObjectNode objectNode, String fieldName) {
        if (objectNode.has(fieldName)) {
            return objectNode.get(fieldName).asText();
        }
        return null;
    }

    public static Date getDateFromJson(ObjectNode objectNode, String fieldName) {
        String s = AsyncHistoryJsonUtil.getStringFromJson(objectNode, fieldName);
        return AsyncHistoryDateUtil.parseDate(s);
    }

    public static Integer getIntegerFromJson(ObjectNode objectNode, String fieldName) {
        String s = AsyncHistoryJsonUtil.getStringFromJson(objectNode, fieldName);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            return Integer.valueOf(s);
        }
        return null;
    }

    public static Double getDoubleFromJson(ObjectNode objectNode, String fieldName) {
        String s = AsyncHistoryJsonUtil.getStringFromJson(objectNode, fieldName);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            return Double.valueOf(s);
        }
        return null;
    }

    public static Long getLongFromJson(ObjectNode objectNode, String fieldName) {
        String s = AsyncHistoryJsonUtil.getStringFromJson(objectNode, fieldName);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            return Long.valueOf(s);
        }
        return null;
    }

    public static Boolean getBooleanFromJson(ObjectNode objectNode, String fieldName, Boolean defaultValue) {
        Boolean value = AsyncHistoryJsonUtil.getBooleanFromJson(objectNode, fieldName);
        return value != null ? value : defaultValue;
    }

    public static Boolean getBooleanFromJson(ObjectNode objectNode, String fieldName) {
        String s = AsyncHistoryJsonUtil.getStringFromJson(objectNode, fieldName);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            return Boolean.valueOf(s);
        }
        return null;
    }
}

