/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.persistence.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.flowable.job.service.impl.persistence.entity.AbstractJobServiceEntity;
import org.flowable.job.service.impl.persistence.entity.AbstractRuntimeJobEntity;
import org.flowable.job.service.impl.persistence.entity.JobByteArrayRef;

public abstract class AbstractJobEntityImpl
extends AbstractJobServiceEntity
implements AbstractRuntimeJobEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Date createTime;
    protected Date duedate;
    protected String executionId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String scopeId;
    protected String subScopeId;
    protected String scopeType;
    protected String scopeDefinitionId;
    protected boolean isExclusive = true;
    protected int retries;
    protected int maxIterations;
    protected String repeat;
    protected Date endDate;
    protected String jobHandlerType;
    protected String jobHandlerConfiguration;
    protected JobByteArrayRef customValuesByteArrayRef;
    protected JobByteArrayRef exceptionByteArrayRef;
    protected String exceptionMessage;
    protected String tenantId = "";
    protected String jobType;

    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("retries", this.retries);
        persistentState.put("createTime", this.createTime);
        persistentState.put("duedate", this.duedate);
        persistentState.put("exceptionMessage", this.exceptionMessage);
        persistentState.put("jobHandlerType", this.jobHandlerType);
        persistentState.put("processDefinitionId", this.processDefinitionId);
        if (this.customValuesByteArrayRef != null) {
            persistentState.put("customValuesByteArrayRef", this.customValuesByteArrayRef);
        }
        if (this.exceptionByteArrayRef != null) {
            persistentState.put("exceptionByteArrayRef", this.exceptionByteArrayRef);
        }
        return persistentState;
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getDuedate() {
        return this.duedate;
    }

    @Override
    public void setDuedate(Date duedate) {
        this.duedate = duedate;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public int getRetries() {
        return this.retries;
    }

    @Override
    public void setRetries(int retries) {
        this.retries = retries;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public boolean isExclusive() {
        return this.isExclusive;
    }

    @Override
    public void setExclusive(boolean isExclusive) {
        this.isExclusive = isExclusive;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    @Override
    public void setScopeId(String scopeId) {
        this.scopeId = scopeId;
    }

    public String getSubScopeId() {
        return this.subScopeId;
    }

    @Override
    public void setSubScopeId(String subScopeId) {
        this.subScopeId = subScopeId;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    @Override
    public void setScopeType(String scopeType) {
        this.scopeType = scopeType;
    }

    public String getScopeDefinitionId() {
        return this.scopeDefinitionId;
    }

    @Override
    public void setScopeDefinitionId(String scopeDefinitionId) {
        this.scopeDefinitionId = scopeDefinitionId;
    }

    @Override
    public String getRepeat() {
        return this.repeat;
    }

    @Override
    public void setRepeat(String repeat) {
        this.repeat = repeat;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    public int getMaxIterations() {
        return this.maxIterations;
    }

    @Override
    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public String getJobHandlerType() {
        return this.jobHandlerType;
    }

    @Override
    public void setJobHandlerType(String jobHandlerType) {
        this.jobHandlerType = jobHandlerType;
    }

    public String getJobHandlerConfiguration() {
        return this.jobHandlerConfiguration;
    }

    @Override
    public void setJobHandlerConfiguration(String jobHandlerConfiguration) {
        this.jobHandlerConfiguration = jobHandlerConfiguration;
    }

    @Override
    public JobByteArrayRef getCustomValuesByteArrayRef() {
        return this.customValuesByteArrayRef;
    }

    @Override
    public String getCustomValues() {
        return this.getJobByteArrayRefAsString(this.customValuesByteArrayRef);
    }

    @Override
    public void setCustomValues(String customValues) {
        if (this.customValuesByteArrayRef == null) {
            this.customValuesByteArrayRef = new JobByteArrayRef();
        }
        this.customValuesByteArrayRef.setValue("jobCustomValues", customValues);
    }

    public String getJobType() {
        return this.jobType;
    }

    @Override
    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getExceptionStacktrace() {
        return this.getJobByteArrayRefAsString(this.exceptionByteArrayRef);
    }

    @Override
    public void setExceptionStacktrace(String exception) {
        if (this.exceptionByteArrayRef == null) {
            this.exceptionByteArrayRef = new JobByteArrayRef();
        }
        this.exceptionByteArrayRef.setValue("stacktrace", exception);
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    @Override
    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = StringUtils.abbreviate((String)exceptionMessage, (int)255);
    }

    @Override
    public JobByteArrayRef getExceptionByteArrayRef() {
        return this.exceptionByteArrayRef;
    }

    private String getJobByteArrayRefAsString(JobByteArrayRef jobByteArrayRef) {
        if (jobByteArrayRef == null) {
            return null;
        }
        return jobByteArrayRef.asString();
    }

    public String toString() {
        return this.getClass().getName() + " [id=" + this.id + "]";
    }
}

