/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.identity;

import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.engine.IdentityService;
import org.flowable.idm.api.User;
import org.flowable.idm.api.UserQuery;
import org.flowable.rest.service.api.BpmnRestApiInterceptor;
import org.flowable.rest.service.api.RestResponseFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseUserResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected IdentityService identityService;
    @Autowired(required=false)
    protected BpmnRestApiInterceptor restApiInterceptor;

    protected User getUserFromRequest(String userId) {
        User user = (User)((UserQuery)this.identityService.createUserQuery().userId(userId)).singleResult();
        if (user == null) {
            throw new FlowableObjectNotFoundException("Could not find a user with id '" + userId + "'.", User.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessUserInfoById(user);
        }
        return user;
    }
}

