/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.identity;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.engine.IdentityService;
import org.flowable.idm.api.User;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.identity.BaseUserResource;
import org.flowable.rest.service.api.identity.UserInfoRequest;
import org.flowable.rest.service.api.identity.UserInfoResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Users"}, description="Manage Users", authorizations={@Authorization(value="basicAuth")})
public class UserInfoResource
extends BaseUserResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected IdentityService identityService;

    @ApiOperation(value="Get a user\u2019s info", tags={"Users"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the user was found and the user has info for the given key."), @ApiResponse(code=404, message="Indicates the requested user was not found or the user does ot have info for the given key. Status description contains additional information about the error.")})
    @GetMapping(value={"/identity/users/{userId}/info/{key}"}, produces={"application/json"})
    public UserInfoResponse getUserInfo(@ApiParam(name="userId") @PathVariable(value="userId") String userId, @ApiParam(name="key") @PathVariable(value="key") String key) {
        User user = this.getUserFromRequest(userId);
        String existingValue = this.identityService.getUserInfo(user.getId(), key);
        if (existingValue == null) {
            throw new FlowableObjectNotFoundException("User info with key '" + key + "' does not exists for user '" + user.getId() + "'.", null);
        }
        return this.restResponseFactory.createUserInfoResponse(key, existingValue, user.getId());
    }

    @ApiOperation(value="Update a user\u2019s info", tags={"Users"}, nickname="updateUserInfo")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the user was found and the info has been updated."), @ApiResponse(code=400, message="Indicates the value was missing from the request body."), @ApiResponse(code=404, message="Indicates the requested user was not found or the user does not have info for the given key. Status description contains additional information about the error.")})
    @PutMapping(value={"/identity/users/{userId}/info/{key}"}, produces={"application/json"})
    public UserInfoResponse setUserInfo(@ApiParam(name="userId") @PathVariable(value="userId") String userId, @ApiParam(name="key") @PathVariable(value="key") String key, @RequestBody UserInfoRequest userRequest) {
        User user = this.getUserFromRequest(userId);
        String validKey = this.getValidKeyFromRequest(user, key);
        if (userRequest.getValue() == null) {
            throw new FlowableIllegalArgumentException("The value cannot be null.");
        }
        if (userRequest.getKey() != null && !validKey.equals(userRequest.getKey())) {
            throw new FlowableIllegalArgumentException("Key provided in request body does not match the key in the resource URL.");
        }
        this.identityService.setUserInfo(user.getId(), key, userRequest.getValue());
        return this.restResponseFactory.createUserInfoResponse(key, userRequest.getValue(), user.getId());
    }

    @ApiOperation(value="Delete a user\u2019s info", tags={"Users"}, code=204)
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the user was found and the info for the given key has been deleted. Response body is left empty intentionally."), @ApiResponse(code=404, message="Indicates the requested user was not found or the user does not have info for the given key. Status description contains additional information about the error.")})
    @DeleteMapping(value={"/identity/users/{userId}/info/{key}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteUserInfo(@ApiParam(name="userId") @PathVariable(value="userId") String userId, @ApiParam(name="key") @PathVariable(value="key") String key) {
        User user = this.getUserFromRequest(userId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.deleteUser(user);
        }
        String validKey = this.getValidKeyFromRequest(user, key);
        this.identityService.setUserInfo(user.getId(), validKey, null);
    }

    protected String getValidKeyFromRequest(User user, String key) {
        String existingValue = this.identityService.getUserInfo(user.getId(), key);
        if (existingValue == null) {
            throw new FlowableObjectNotFoundException("User info with key '" + key + "' does not exists for user '" + user.getId() + "'.", null);
        }
        return key;
    }
}

