/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.management;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Map;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.engine.ManagementService;
import org.flowable.rest.service.api.BpmnRestApiInterceptor;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.management.TableResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Database tables"}, description="Manage Database tables", authorizations={@Authorization(value="basicAuth")})
public class TableResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected ManagementService managementService;
    @Autowired(required=false)
    protected BpmnRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="Get a single table", tags={"Database tables"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the table exists and the table count is returned."), @ApiResponse(code=404, message="Indicates the requested table does not exist.")})
    @GetMapping(value={"/management/tables/{tableName}"}, produces={"application/json"})
    public TableResponse getTable(@ApiParam(name="tableName") @PathVariable String tableName) {
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessTableInfo();
        }
        Map tableCounts = this.managementService.getTableCount();
        TableResponse response = null;
        for (Map.Entry entry : tableCounts.entrySet()) {
            if (!((String)entry.getKey()).equals(tableName)) continue;
            response = this.restResponseFactory.createTableResponse((String)entry.getKey(), (Long)entry.getValue());
            break;
        }
        if (response == null) {
            throw new FlowableObjectNotFoundException("Could not find a table with name '" + tableName + "'.", String.class);
        }
        return response;
    }
}

