/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import jakarta.servlet.http.HttpServletResponse;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.rest.service.api.repository.BaseDeploymentResourceDataResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Process Definitions"}, description="Manage Process Definitions", authorizations={@Authorization(value="basicAuth")})
public class ProcessDefinitionResourceDataResource
extends BaseDeploymentResourceDataResource {
    @ApiOperation(value="Get a process definition resource content", tags={"Process Definitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates both process definition and resource have been found and the resource data has been returned."), @ApiResponse(code=404, message="Indicates the requested process definition was not found or there is no resource with the given id present in the process definition. The status-description contains additional information.")})
    @GetMapping(value={"/repository/process-definitions/{processDefinitionId}/resourcedata"})
    public byte[] getProcessDefinitionResource(@ApiParam(name="processDefinitionId") @PathVariable String processDefinitionId, HttpServletResponse response) {
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest(processDefinitionId);
        return this.getDeploymentResourceData(processDefinition.getDeploymentId(), processDefinition.getResourceName(), response);
    }

    protected ProcessDefinition getProcessDefinitionFromRequest(String processDefinitionId) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
        if (processDefinition == null) {
            throw new FlowableObjectNotFoundException("Could not find a process definition with id '" + processDefinitionId + "'.", ProcessDefinition.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessProcessDefinitionById(processDefinition);
        }
        return processDefinition;
    }
}

