/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.process;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.identitylink.api.IdentityLink;
import org.flowable.rest.service.api.engine.RestIdentityLink;
import org.flowable.rest.service.api.runtime.process.BaseProcessInstanceResource;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Process Instance Identity Links"}, description="Manage Process Instances Identity Links", authorizations={@Authorization(value="basicAuth")})
public class ProcessInstanceIdentityLinkResource
extends BaseProcessInstanceResource {
    @ApiOperation(value="Get a specific involved people from process instance", tags={"Process Instance Identity Links"}, nickname="getProcessInstanceIdentityLinks")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the process instance was found and the specified link is retrieved."), @ApiResponse(code=404, message="Indicates the requested process instance was not found or the link to delete does not exist. The response status contains additional information about the error.")})
    @GetMapping(value={"/runtime/process-instances/{processInstanceId}/identitylinks/users/{identityId}/{type}"}, produces={"application/json"})
    public RestIdentityLink getIdentityLinkRequest(@ApiParam(name="processInstanceId") @PathVariable(value="processInstanceId") String processInstanceId, @ApiParam(name="identityId") @PathVariable(value="identityId") String identityId, @ApiParam(name="type") @PathVariable(value="type") String type) {
        ProcessInstance processInstance = this.getProcessInstanceFromRequestWithoutAccessCheck(processInstanceId);
        this.validateIdentityLinkArguments(identityId, type);
        IdentityLink link = this.getIdentityLink(identityId, type, processInstance.getId());
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessProcessInstanceIdentityLink(processInstance, link);
        }
        return this.restResponseFactory.createRestIdentityLink(link);
    }

    @ApiOperation(value="Remove an involved user to from process instance", tags={"Process Instance Identity Links"}, nickname="deleteProcessInstanceIdentityLinks", code=204)
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the process instance was found and the link has been deleted. Response body is left empty intentionally."), @ApiResponse(code=404, message="Indicates the requested process instance was not found or the link to delete does not exist. The response status contains additional information about the error.")})
    @DeleteMapping(value={"/runtime/process-instances/{processInstanceId}/identitylinks/users/{identityId}/{type}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteIdentityLink(@ApiParam(name="processInstanceId") @PathVariable(value="processInstanceId") String processInstanceId, @ApiParam(name="identityId") @PathVariable(value="identityId") String identityId, @ApiParam(name="type") @PathVariable(value="type") String type) {
        ProcessInstance processInstance = this.getProcessInstanceFromRequestWithoutAccessCheck(processInstanceId);
        this.validateIdentityLinkArguments(identityId, type);
        IdentityLink link = this.getIdentityLink(identityId, type, processInstance.getId());
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.deleteProcessInstanceIdentityLink(processInstance, link);
        }
        this.runtimeService.deleteUserIdentityLink(processInstance.getId(), identityId, type);
    }

    protected void validateIdentityLinkArguments(String identityId, String type) {
        if (identityId == null) {
            throw new FlowableIllegalArgumentException("IdentityId is required.");
        }
        if (type == null) {
            throw new FlowableIllegalArgumentException("Type is required.");
        }
    }

    protected IdentityLink getIdentityLink(String identityId, String type, String processInstanceId) {
        List allLinks = this.runtimeService.getIdentityLinksForProcessInstance(processInstanceId);
        for (IdentityLink link : allLinks) {
            if (!identityId.equals(link.getUserId()) || !link.getType().equals(type)) continue;
            return link;
        }
        throw new FlowableObjectNotFoundException("Could not find the requested identity link.", IdentityLink.class);
    }
}

