/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.form;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.flowable.app.spring.SpringAppEngineConfiguration;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.EngineConfigurator;
import org.flowable.common.spring.AutoDeploymentStrategy;
import org.flowable.common.spring.CommonAutoDeploymentProperties;
import org.flowable.common.spring.SpringEngineConfiguration;
import org.flowable.form.engine.FormEngine;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.configurator.FormEngineConfigurator;
import org.flowable.form.spring.SpringFormEngineConfiguration;
import org.flowable.form.spring.autodeployment.DefaultAutoDeploymentStrategy;
import org.flowable.form.spring.autodeployment.ResourceParentFolderAutoDeploymentStrategy;
import org.flowable.form.spring.autodeployment.SingleResourceAutoDeploymentStrategy;
import org.flowable.form.spring.configurator.SpringFormEngineConfigurator;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.flowable.spring.boot.AbstractSpringEngineAutoConfiguration;
import org.flowable.spring.boot.BaseEngineConfigurationWithConfigurers;
import org.flowable.spring.boot.EngineConfigurationConfigurer;
import org.flowable.spring.boot.FlowableAutoDeploymentProperties;
import org.flowable.spring.boot.FlowableProperties;
import org.flowable.spring.boot.ProcessEngineAutoConfiguration;
import org.flowable.spring.boot.ProcessEngineServicesAutoConfiguration;
import org.flowable.spring.boot.app.AppEngineAutoConfiguration;
import org.flowable.spring.boot.app.AppEngineServicesAutoConfiguration;
import org.flowable.spring.boot.condition.ConditionalOnFormEngine;
import org.flowable.spring.boot.form.FlowableFormProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration(proxyBeanMethods=false)
@ConditionalOnFormEngine
@EnableConfigurationProperties(value={FlowableProperties.class, FlowableAutoDeploymentProperties.class, FlowableFormProperties.class})
@AutoConfigureAfter(value={AppEngineAutoConfiguration.class, ProcessEngineAutoConfiguration.class})
@AutoConfigureBefore(value={AppEngineServicesAutoConfiguration.class, ProcessEngineServicesAutoConfiguration.class})
public class FormEngineAutoConfiguration
extends AbstractSpringEngineAutoConfiguration {
    protected final FlowableFormProperties formProperties;
    protected final FlowableAutoDeploymentProperties autoDeploymentProperties;

    public FormEngineAutoConfiguration(FlowableProperties flowableProperties, FlowableFormProperties formProperties, FlowableAutoDeploymentProperties autoDeploymentProperties) {
        super(flowableProperties);
        this.formProperties = formProperties;
        this.autoDeploymentProperties = autoDeploymentProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringFormEngineConfiguration formEngineConfiguration(DataSource dataSource, PlatformTransactionManager platformTransactionManager, ObjectProvider<ObjectMapper> objectMapperProvider, ObjectProvider<List<AutoDeploymentStrategy<FormEngine>>> formAutoDeploymentStrategies) throws IOException {
        ArrayList<Object> deploymentStrategies;
        SpringFormEngineConfiguration configuration = new SpringFormEngineConfiguration();
        List<Resource> resources = this.discoverDeploymentResources(this.formProperties.getResourceLocation(), this.formProperties.getResourceSuffixes(), this.formProperties.isDeployResources());
        if (resources != null && !resources.isEmpty()) {
            configuration.setDeploymentResources(resources.toArray(new Resource[0]));
            configuration.setDeploymentName(this.formProperties.getDeploymentName());
        }
        this.configureSpringEngine((SpringEngineConfiguration)configuration, platformTransactionManager);
        this.configureEngine((AbstractEngineConfiguration)configuration, dataSource);
        ObjectMapper objectMapper = (ObjectMapper)objectMapperProvider.getIfAvailable();
        if (objectMapper != null) {
            configuration.setObjectMapper(objectMapper);
        }
        if ((deploymentStrategies = (ArrayList<Object>)formAutoDeploymentStrategies.getIfAvailable()) == null) {
            deploymentStrategies = new ArrayList<Object>();
        }
        CommonAutoDeploymentProperties deploymentProperties = this.autoDeploymentProperties.deploymentPropertiesForEngine("form");
        deploymentStrategies.add(new DefaultAutoDeploymentStrategy(deploymentProperties));
        deploymentStrategies.add(new SingleResourceAutoDeploymentStrategy(deploymentProperties));
        deploymentStrategies.add(new ResourceParentFolderAutoDeploymentStrategy(deploymentProperties));
        configuration.setDeploymentStrategies(deploymentStrategies);
        return configuration;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(type={"org.flowable.app.spring.SpringAppEngineConfiguration"})
    public static class FormEngineAppEngineConfiguration
    extends BaseEngineConfigurationWithConfigurers<SpringFormEngineConfiguration> {
        @Bean
        @ConditionalOnMissingBean(name={"formAppEngineConfigurationConfigurer"})
        public EngineConfigurationConfigurer<SpringAppEngineConfiguration> formAppEngineConfigurationConfigurer(FormEngineConfigurator formEngineConfigurator) {
            return appEngineConfiguration -> appEngineConfiguration.addConfigurator((EngineConfigurator)formEngineConfigurator);
        }

        @Bean
        @ConditionalOnMissingBean
        public FormEngineConfigurator formEngineConfigurator(SpringFormEngineConfiguration configuration) {
            SpringFormEngineConfigurator formEngineConfigurator = new SpringFormEngineConfigurator();
            formEngineConfigurator.setFormEngineConfiguration((FormEngineConfiguration)configuration);
            this.invokeConfigurers(configuration);
            return formEngineConfigurator;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(type={"org.flowable.spring.SpringProcessEngineConfiguration"})
    @ConditionalOnMissingBean(type={"org.flowable.app.spring.SpringAppEngineConfiguration"})
    public static class FormEngineProcessConfiguration
    extends BaseEngineConfigurationWithConfigurers<SpringFormEngineConfiguration> {
        @Bean
        @ConditionalOnMissingBean(name={"formProcessEngineConfigurationConfigurer"})
        public EngineConfigurationConfigurer<SpringProcessEngineConfiguration> formProcessEngineConfigurationConfigurer(FormEngineConfigurator formEngineConfigurator) {
            return processEngineConfiguration -> processEngineConfiguration.addConfigurator((EngineConfigurator)formEngineConfigurator);
        }

        @Bean
        @ConditionalOnMissingBean
        public FormEngineConfigurator formEngineConfigurator(SpringFormEngineConfiguration configuration) {
            SpringFormEngineConfigurator formEngineConfigurator = new SpringFormEngineConfigurator();
            formEngineConfigurator.setFormEngineConfiguration((FormEngineConfiguration)configuration);
            this.invokeConfigurers(configuration);
            return formEngineConfigurator;
        }
    }
}

