/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.rest.app;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.model.form.FormRepresentation;
import org.flowable.ui.modeler.repository.ModelRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/form-models"})
public class FormsResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormsResource.class);
    private static final int MIN_FILTER_LENGTH = 2;
    @Autowired
    protected ModelRepository modelRepository;
    @Autowired
    protected ObjectMapper objectMapper;

    @GetMapping(produces={"application/json"})
    public ResultListDataRepresentation getForms(HttpServletRequest request) {
        String filter = null;
        List params = URLEncodedUtils.parse((String)request.getQueryString(), (Charset)StandardCharsets.UTF_8);
        if (params != null) {
            for (NameValuePair nameValuePair : params) {
                if (!"filter".equalsIgnoreCase(nameValuePair.getName())) continue;
                filter = nameValuePair.getValue();
            }
        }
        String validFilter = this.makeValidFilterText(filter);
        List models = null;
        models = validFilter != null ? this.modelRepository.findByModelTypeAndFilter(Integer.valueOf(2), validFilter, "nameAsc") : this.modelRepository.findByModelType(Integer.valueOf(2), "nameAsc");
        ArrayList<FormRepresentation> reps = new ArrayList<FormRepresentation>();
        for (Model model : models) {
            reps.add(new FormRepresentation((AbstractModel)model));
        }
        Collections.sort(reps, new NameComparator());
        ResultListDataRepresentation result = new ResultListDataRepresentation(reps);
        result.setTotal(Long.valueOf(models.size()));
        return result;
    }

    protected String makeValidFilterText(String filterText) {
        String trimmed;
        String validFilter = null;
        if (filterText != null && (trimmed = StringUtils.trim((String)filterText)).length() >= 2) {
            validFilter = "%" + trimmed.toLowerCase() + "%";
        }
        return validFilter;
    }

    class NameComparator
    implements Comparator<FormRepresentation> {
        NameComparator() {
        }

        @Override
        public int compare(FormRepresentation o1, FormRepresentation o2) {
            return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
        }
    }
}

