/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.rest.app;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class StencilSetResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(StencilSetResource.class);
    @Autowired
    protected ObjectMapper objectMapper;

    @GetMapping(value={"/rest/stencil-sets/editor"}, produces={"application/json"})
    public JsonNode getStencilSetForEditor() {
        try {
            JsonNode stencilNode = this.objectMapper.readTree(this.getClass().getClassLoader().getResourceAsStream("stencilset_bpmn.json"));
            return stencilNode;
        }
        catch (Exception e) {
            LOGGER.error("Error reading bpmn stencil set json", (Throwable)e);
            throw new InternalServerErrorException("Error reading bpmn stencil set json");
        }
    }

    @GetMapping(value={"/rest/stencil-sets/cmmneditor"}, produces={"application/json"})
    public JsonNode getCmmnStencilSetForEditor() {
        try {
            JsonNode stencilNode = this.objectMapper.readTree(this.getClass().getClassLoader().getResourceAsStream("stencilset_cmmn.json"));
            return stencilNode;
        }
        catch (Exception e) {
            LOGGER.error("Error reading cmmn stencil set json", (Throwable)e);
            throw new InternalServerErrorException("Error reading cmmn stencil set json");
        }
    }

    @GetMapping(value={"/rest/stencil-sets/dmneditor"}, produces={"application/json"})
    public JsonNode getDmnStencilSetForEditor() {
        try {
            JsonNode stencilNode = this.objectMapper.readTree(this.getClass().getClassLoader().getResourceAsStream("stencilset_dmn.json"));
            return stencilNode;
        }
        catch (Exception e) {
            LOGGER.error("Error reading dmn stencil set json", (Throwable)e);
            throw new InternalServerErrorException("Error reading dmn stencil set json");
        }
    }
}

