/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.scanner.filesystem;

import java.io.File;
import java.util.Collection;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.scanner.ReadOnlyLocationHandler;
import org.flywaydb.core.internal.scanner.filesystem.FileSystemScanner;

public class FilesystemLocationHandler
implements ReadOnlyLocationHandler {
    private static final String FILESYSTEM_PREFIX = "filesystem:";

    @Override
    public boolean canHandlePrefix(String prefix) {
        return FILESYSTEM_PREFIX.equals(prefix);
    }

    @Override
    public Collection<LoadableResource> scanForResources(Location location, Configuration configuration) {
        boolean stream = configuration.isStream();
        FileSystemScanner fileSystemScanner = new FileSystemScanner(stream, configuration);
        return fileSystemScanner.scanForResources(location);
    }

    @Override
    public boolean handlesWildcards() {
        return true;
    }

    @Override
    public String getPathSeparator() {
        return File.separator;
    }

    @Override
    public String normalizePath(String path) {
        return new File(path).getPath();
    }
}

