/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.extensibility;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.flywaydb.core.extensibility.ConfigurationParameter;
import org.flywaydb.core.extensibility.Plugin;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StringUtils;

public interface PluginMetadata
extends Plugin {
    default public String getHelpText() {
        StringBuilder result = new StringBuilder();
        String indent = "    ";
        String description = this.getDescription();
        List<ConfigurationParameter> configurationParameters = this.getConfigurationParameters();
        List<ConfigurationParameter> flags = this.getFlags();
        String example = this.getExample();
        String documentationLink = this.getDocumentationLink();
        if (this.inPreview()) {
            result.append("(In preview)\n\n");
        }
        if (description != null) {
            result.append("Description:\n");
            Arrays.stream(description.split("\n")).map(String::trim).forEach(line -> result.append(indent).append((String)line).append("\n"));
            result.append("\n");
        }
        int padSize = 0;
        if (configurationParameters != null) {
            padSize = configurationParameters.stream().map(p -> p.name + (p.required ? " [REQUIRED]" : "")).mapToInt(String::length).max().orElse(0) + 2;
        }
        if (flags != null) {
            padSize = Math.max(padSize, flags.stream().map(p -> p.name + (p.required ? " [REQUIRED]" : "")).mapToInt(String::length).max().orElse(0) + 2);
        }
        if (configurationParameters != null) {
            result.append("Configuration parameters: (Format: -key=value)\n");
            for (ConfigurationParameter p2 : configurationParameters) {
                String parameterName = p2.name.startsWith("flyway.") ? p2.name.substring("flyway.".length()) : p2.name;
                String fullParameter = parameterName + (p2.required ? " [REQUIRED]" : "");
                result.append(indent).append(StringUtils.rightPad(fullParameter, padSize, ' '));
                String descriptionPadding = " ".repeat(indent.length() + padSize);
                List<String> descriptionLines = Arrays.stream(p2.description.split("\n")).toList();
                result.append(descriptionLines.get(0)).append("\n");
                for (int i = 1; i < descriptionLines.size(); ++i) {
                    result.append(descriptionPadding).append(descriptionLines.get(i)).append("\n");
                }
            }
            result.append("\n");
        }
        if (flags != null) {
            result.append("Flags:\n");
            for (ConfigurationParameter p2 : flags) {
                String flagName = p2.name + (p2.required ? " [REQUIRED]" : "");
                result.append(indent).append(StringUtils.rightPad(flagName, padSize, ' ')).append(p2.description).append("\n");
            }
            result.append("\n");
        }
        if (example != null) {
            result.append("Example:\n").append(indent).append(example).append("\n\n");
        }
        if (documentationLink != null) {
            result.append("Online documentation: ").append(documentationLink).append("\n");
        }
        return result.toString();
    }

    default public String getDescription() {
        return null;
    }

    default public List<ConfigurationParameter> getConfigurationParameters() {
        return null;
    }

    default public List<ConfigurationParameter> getFlags() {
        return null;
    }

    default public String getExample() {
        return null;
    }

    default public List<Pair<String, String>> getUsage() {
        return Collections.emptyList();
    }

    default public String getDocumentationLink() {
        return null;
    }

    default public boolean inPreview() {
        return false;
    }
}

