/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.ddd;

import javax.json.bind.annotation.JsonbProperty;
import javax.json.bind.annotation.JsonbTypeAdapter;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.fuin.ddd4j.ddd.AbstractEvent;
import org.fuin.ddd4j.ddd.AggregateRootId;
import org.fuin.ddd4j.ddd.AggregateVersion;
import org.fuin.ddd4j.ddd.AggregateVersionConverter;
import org.fuin.ddd4j.ddd.DomainEvent;
import org.fuin.ddd4j.ddd.EntityId;
import org.fuin.ddd4j.ddd.EntityIdPath;
import org.fuin.ddd4j.ddd.EntityIdPathConverter;
import org.fuin.ddd4j.ddd.Event;
import org.fuin.ddd4j.ddd.EventId;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.Nullable;

public abstract class AbstractDomainEvent<ID extends EntityId>
extends AbstractEvent
implements DomainEvent<ID> {
    private static final long serialVersionUID = 1000L;
    @NotNull
    @JsonbTypeAdapter(value=EntityIdPathConverter.class)
    @JsonbProperty(value="entity-id-path")
    @XmlJavaTypeAdapter(value=EntityIdPathConverter.class)
    @XmlElement(name="entity-id-path")
    private EntityIdPath entityIdPath;
    @Nullable
    @JsonbTypeAdapter(value=AggregateVersionConverter.class)
    @JsonbProperty(value="aggregate-version")
    @XmlJavaTypeAdapter(value=AggregateVersionConverter.class)
    @XmlElement(name="aggregate-version")
    private AggregateVersion aggregateVersion;

    protected AbstractDomainEvent() {
    }

    public AbstractDomainEvent(@NotNull EntityIdPath entityIdPath) {
        this.entityIdPath = entityIdPath;
    }

    public AbstractDomainEvent(@NotNull EntityIdPath entityIdPath, @NotNull Event respondTo) {
        super(respondTo);
        this.entityIdPath = entityIdPath;
    }

    public AbstractDomainEvent(@NotNull EntityIdPath entityIdPath, @Nullable EventId correlationId, @Nullable EventId causationId) {
        super(correlationId, causationId);
        this.entityIdPath = entityIdPath;
    }

    @Override
    public final EntityIdPath getEntityIdPath() {
        return this.entityIdPath;
    }

    @Override
    public final ID getEntityId() {
        return (ID)this.entityIdPath.last();
    }

    @Override
    @Nullable
    public final AggregateVersion getAggregateVersion() {
        return this.aggregateVersion;
    }

    @Override
    @Nullable
    public final Integer getAggregateVersionInteger() {
        if (this.aggregateVersion == null) {
            return null;
        }
        return this.aggregateVersion.asBaseType();
    }

    protected static abstract class Builder<ID extends EntityId, TYPE extends AbstractDomainEvent<ID>, BUILDER extends Builder<ID, TYPE, BUILDER>>
    extends AbstractEvent.Builder<TYPE, BUILDER> {
        private AbstractDomainEvent<ID> delegate;

        public Builder(TYPE delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        public final BUILDER entityIdPath(@NotNull EntityIdPath entityIdPath) {
            Contract.requireArgNotNull((String)"entityIdPath", (Object)entityIdPath);
            this.delegate.entityIdPath = entityIdPath;
            return (BUILDER)this;
        }

        public final BUILDER entityIdPath(@NotNull AggregateRootId id) {
            Contract.requireArgNotNull((String)"id", (Object)id);
            this.delegate.entityIdPath = new EntityIdPath(id);
            return (BUILDER)this;
        }

        public final BUILDER aggregateVersion(AggregateVersion aggregateVersion) {
            this.delegate.aggregateVersion = aggregateVersion;
            return (BUILDER)this;
        }

        protected final void ensureBuildableAbstractDomainEvent() {
            this.ensureBuildableAbstractEvent();
            this.ensureNotNull("entityIdPath", this.delegate.entityIdPath);
        }

        protected final void resetAbstractDomainEvent(TYPE delegate) {
            this.resetAbstractEvent(delegate);
            this.delegate = delegate;
        }
    }
}

