/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.ddd;

import java.io.Serializable;
import javax.json.bind.annotation.JsonbProperty;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.fuin.ddd4j.ddd.EntityId;
import org.fuin.ddd4j.ddd.EntityIdPath;
import org.fuin.objects4j.common.ExceptionShortIdentifable;
import org.fuin.objects4j.common.MarshalInformation;
import org.fuin.objects4j.common.Nullable;
import org.fuin.objects4j.common.ToExceptionCapable;
import org.fuin.objects4j.vo.ValueObject;

public final class EntityNotFoundException
extends Exception
implements ExceptionShortIdentifable,
MarshalInformation<Data> {
    private static final long serialVersionUID = 1L;
    public static final String SHORT_ID = "DDD4J-ENTITY_NOT_FOUND";
    public static final String ELEMENT_NAME = "entity-not-found-exception";
    private final Data data;

    public EntityNotFoundException(@Nullable EntityIdPath parentIdPath, @NotNull EntityId entityId) {
        super(parentIdPath == null ? entityId.asTypedString() + " not found" : entityId.asTypedString() + " not found in " + parentIdPath.asString());
        String pidp = parentIdPath == null ? null : parentIdPath.asString();
        this.data = new Data(this.getMessage(), SHORT_ID, pidp, entityId.asString());
    }

    public EntityNotFoundException(@NotNull EntityIdPath entityIdPath) {
        this(entityIdPath.parent(), (EntityId)entityIdPath.last());
    }

    private EntityNotFoundException(Data data) {
        super(data.message);
        this.data = data;
    }

    public final String getShortId() {
        return this.data.sid;
    }

    @NotNull
    public final String getParentIdPath() {
        return this.data.parentIdPath;
    }

    @NotNull
    public final String getEntityId() {
        return this.data.entityId;
    }

    public final Data getData() {
        return this.data;
    }

    public Class<Data> getDataClass() {
        return Data.class;
    }

    public String getDataElement() {
        return ELEMENT_NAME;
    }

    @XmlRootElement(name="entity-not-found-exception")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static final class Data
    implements Serializable,
    ValueObject,
    ToExceptionCapable<EntityNotFoundException> {
        private static final long serialVersionUID = 1000L;
        @JsonbProperty(value="msg")
        @XmlElement(name="msg")
        private String message;
        @JsonbProperty(value="sid")
        @XmlElement(name="sid")
        private String sid;
        @JsonbProperty(value="parent-id-path")
        @XmlElement(name="parent-id-path")
        private String parentIdPath;
        @JsonbProperty(value="entity-id")
        @XmlElement(name="entity-id")
        private String entityId;

        protected Data() {
        }

        private Data(String message, String sid, String parentIdPath, String entityId) {
            this.message = message;
            this.sid = sid;
            this.parentIdPath = parentIdPath;
            this.entityId = entityId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.entityId == null ? 0 : this.entityId.hashCode());
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            result = 31 * result + (this.parentIdPath == null ? 0 : this.parentIdPath.hashCode());
            result = 31 * result + (this.sid == null ? 0 : this.sid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Data other = (Data)obj;
            if (this.entityId == null ? other.entityId != null : !this.entityId.equals(other.entityId)) {
                return false;
            }
            if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
                return false;
            }
            if (this.parentIdPath == null ? other.parentIdPath != null : !this.parentIdPath.equals(other.parentIdPath)) {
                return false;
            }
            return !(this.sid == null ? other.sid != null : !this.sid.equals(other.sid));
        }

        public String toString() {
            return "Data [message=" + this.message + ", sid=" + this.sid + ", parentIdPath=" + this.parentIdPath + ", entityId=" + this.entityId + "]";
        }

        public EntityNotFoundException toException() {
            return new EntityNotFoundException(this);
        }
    }
}

