/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.spi;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.validation.constraints.NotNull;
import org.fuin.objects4j.common.Nullable;

public final class EnhancedMimeType
extends MimeType {
    public static final String VERSION = "version";
    public static final String ENCODING = "encoding";

    public EnhancedMimeType() {
    }

    public EnhancedMimeType(@NotNull String str) throws MimeTypeParseException {
        super(str);
    }

    public EnhancedMimeType(@NotNull String primary, @NotNull String sub) throws MimeTypeParseException {
        super(primary, sub);
    }

    public EnhancedMimeType(@NotNull String primary, @NotNull String sub, @Nullable Charset encoding) throws MimeTypeParseException {
        super(primary, sub);
        if (encoding != null) {
            super.setParameter(ENCODING, encoding.name());
        }
    }

    public EnhancedMimeType(@NotNull String primary, @NotNull String sub, @Nullable Charset encoding, @Nullable String version) throws MimeTypeParseException {
        this(primary, sub, encoding, version, null);
    }

    public EnhancedMimeType(@NotNull String primary, @NotNull String sub, @Nullable Charset encoding, @Nullable String version, @Nullable Map<String, String> params) throws MimeTypeParseException {
        super(primary, sub);
        if (encoding != null) {
            super.setParameter(ENCODING, encoding.name());
        }
        if (version != null) {
            super.setParameter(VERSION, version);
        }
        if (params != null) {
            for (String key : params.keySet()) {
                String value = params.get(key);
                if (key.equals(ENCODING)) {
                    throw new IllegalArgumentException("Setting encoding with the parameters is not allowed. Use the 'encoding' argument instead.");
                }
                if (key.equals(VERSION)) {
                    throw new IllegalArgumentException("Setting version with the parameters is not allowed. Use the 'version' argument instead.");
                }
                super.setParameter(key, value);
            }
        }
    }

    @Nullable
    public final String getVersion() {
        return this.getParameter(VERSION);
    }

    @Nullable
    public final Charset getEncoding() {
        String parameter = this.getParameter(ENCODING);
        if (parameter == null) {
            return null;
        }
        return Charset.forName(parameter);
    }

    public final boolean isJson() {
        return this.getBaseType().equals("application/json");
    }

    public final boolean isXml() {
        return this.getBaseType().equals("application/xml");
    }

    public final boolean matchEncoding(EnhancedMimeType other) {
        return this.match(other) && Objects.equals(this.getEncoding(), other.getEncoding());
    }

    @Nullable
    public static EnhancedMimeType create(@Nullable String str) {
        if (str == null) {
            return null;
        }
        try {
            return new EnhancedMimeType(str);
        }
        catch (MimeTypeParseException ex) {
            throw new RuntimeException("Failed to create versioned mime type: " + str, ex);
        }
    }

    @NotNull
    public static EnhancedMimeType create(@NotNull String primary, @NotNull String sub) {
        return EnhancedMimeType.create(primary, sub, null, null, null);
    }

    @NotNull
    public static EnhancedMimeType create(@NotNull String primary, @NotNull String sub, Charset encoding) {
        return EnhancedMimeType.create(primary, sub, encoding, null, null);
    }

    @NotNull
    public static EnhancedMimeType create(@NotNull String primary, @NotNull String sub, Charset encoding, String version) {
        return EnhancedMimeType.create(primary, sub, encoding, version, new HashMap<String, String>());
    }

    @NotNull
    public static EnhancedMimeType create(@NotNull String primary, @NotNull String sub, Charset encoding, String version, Map<String, String> parameters) {
        try {
            return new EnhancedMimeType(primary, sub, encoding, version, parameters);
        }
        catch (MimeTypeParseException ex) {
            throw new RuntimeException("Failed to create versioned mime type: " + primary + "/" + sub, ex);
        }
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnhancedMimeType)) {
            return false;
        }
        EnhancedMimeType other = (EnhancedMimeType)((Object)obj);
        return this.toString().equals(other.toString());
    }
}

