/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.spi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.json.Json;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import org.fuin.esc.spi.EnhancedMimeType;
import org.fuin.esc.spi.SerDeserializer;
import org.fuin.esc.spi.SerializedDataType;
import org.fuin.esc.spi.ToJsonCapable;

public final class JsonDeSerializer
implements SerDeserializer {
    private final EnhancedMimeType mimeType;

    public JsonDeSerializer() {
        this(Charset.forName("utf-8"));
    }

    public JsonDeSerializer(Charset encoding) {
        this.mimeType = EnhancedMimeType.create("application", "json", encoding);
    }

    @Override
    public final EnhancedMimeType getMimeType() {
        return this.mimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] marshal(Object obj, SerializedDataType type) {
        JsonStructure struct;
        if (obj instanceof ToJsonCapable) {
            struct = ((ToJsonCapable)obj).toJson();
        } else if (obj instanceof JsonStructure) {
            struct = (JsonStructure)obj;
        } else {
            throw new IllegalArgumentException("Can only handle instances of type '" + ToJsonCapable.class.getSimpleName() + "' or '" + JsonStructure.class.getSimpleName() + "', but not: " + obj.getClass());
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, this.mimeType.getEncoding());
        try (JsonWriter jsonWriter = Json.createWriter((Writer)writer);){
            jsonWriter.write(struct);
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> T unmarshal(Object data, SerializedDataType type, EnhancedMimeType mimeType) {
        if (data instanceof byte[]) {
            InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream((byte[])data), mimeType.getEncoding());
            try (JsonReader jsonReader = Json.createReader((Reader)reader);){
                JsonStructure jsonStructure = jsonReader.read();
                return (T)jsonStructure;
            }
        }
        if (data instanceof JsonStructure) {
            return (T)data;
        }
        throw new IllegalArgumentException("This deserializer only supports input of type '" + JsonStructure.class.getName() + "' and 'byte[]', but was: " + data);
    }
}

