/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.spi;

import java.io.Serializable;
import java.util.Arrays;
import javax.validation.constraints.NotNull;
import org.fuin.esc.spi.EnhancedMimeType;
import org.fuin.esc.spi.SerializedDataType;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.Immutable;
import org.fuin.objects4j.vo.ValueObject;

@Immutable
public class SerializedData
implements ValueObject,
Serializable {
    private static final long serialVersionUID = 1000L;
    @NotNull
    private String type;
    @NotNull
    private String mimeType;
    @NotNull
    private byte[] raw;

    protected SerializedData() {
    }

    public SerializedData(@NotNull SerializedDataType type, @NotNull EnhancedMimeType mimeType, @NotNull byte[] raw) {
        Contract.requireArgNotNull((String)"type", (Object)((Object)type));
        Contract.requireArgNotNull((String)"mimeType", (Object)((Object)mimeType));
        Contract.requireArgNotNull((String)"raw", (Object)raw);
        this.type = type.asBaseType();
        this.mimeType = mimeType.toString();
        this.raw = raw;
    }

    @NotNull
    public final SerializedDataType getType() {
        return new SerializedDataType(this.type);
    }

    @NotNull
    public final EnhancedMimeType getMimeType() {
        return EnhancedMimeType.create(this.mimeType);
    }

    @NotNull
    public final byte[] getRaw() {
        return this.raw;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
        result = 31 * result + Arrays.hashCode(this.raw);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SerializedData)) {
            return false;
        }
        SerializedData other = (SerializedData)obj;
        if (this.mimeType == null ? other.mimeType != null : !this.mimeType.equals(other.mimeType)) {
            return false;
        }
        if (!Arrays.equals(this.raw, other.raw)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

