/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.spi;

import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.fuin.esc.spi.Deserializer;
import org.fuin.esc.spi.EnhancedMimeType;
import org.fuin.esc.spi.SerDeserializer;
import org.fuin.esc.spi.SerDeserializerRegistry;
import org.fuin.esc.spi.SerializedDataType;
import org.fuin.esc.spi.Serializer;
import org.fuin.objects4j.common.Contract;

public final class SimpleSerializerDeserializerRegistry
implements SerDeserializerRegistry {
    private final Map<SerializedDataType, Serializer> serMap = new HashMap<SerializedDataType, Serializer>();
    private final Map<Key, Deserializer> desMap = new HashMap<Key, Deserializer>();
    private final Map<SerializedDataType, EnhancedMimeType> contentTypes = new HashMap<SerializedDataType, EnhancedMimeType>();

    public final void add(@NotNull SerializedDataType type, String contentType, @NotNull SerDeserializer serDeserializer) {
        this.addSerializer(type, serDeserializer);
        this.addDeserializer(type, contentType, serDeserializer);
    }

    public final void addDeserializer(@NotNull SerializedDataType type, String contentType, @NotNull Deserializer deserializer) {
        Contract.requireArgNotNull((String)"type", (Object)((Object)type));
        Contract.requireArgNotNull((String)"contentType", (Object)contentType);
        Contract.requireArgNotNull((String)"deserializer", (Object)deserializer);
        Key key = new Key(type, contentType);
        this.desMap.put(key, deserializer);
    }

    public final void setDefaultContentType(@NotNull SerializedDataType type, EnhancedMimeType contentType) {
        Contract.requireArgNotNull((String)"type", (Object)((Object)type));
        Contract.requireArgNotNull((String)"contentType", (Object)((Object)contentType));
        this.contentTypes.put(type, contentType);
    }

    public final void addSerializer(@NotNull SerializedDataType type, @NotNull Serializer serializer) {
        Contract.requireArgNotNull((String)"type", (Object)((Object)type));
        Contract.requireArgNotNull((String)"serializer", (Object)serializer);
        this.serMap.put(type, serializer);
    }

    @Override
    public Serializer getSerializer(SerializedDataType type) {
        Contract.requireArgNotNull((String)"type", (Object)((Object)type));
        Serializer ser = this.serMap.get((Object)type);
        if (ser == null) {
            throw new IllegalArgumentException("No serializer found for: " + type);
        }
        return ser;
    }

    @Override
    public final Deserializer getDeserializer(SerializedDataType type, EnhancedMimeType mimeType) {
        Contract.requireArgNotNull((String)"type", (Object)((Object)type));
        Contract.requireArgNotNull((String)"mimeType", (Object)((Object)mimeType));
        Key key = new Key(type, mimeType.getBaseType());
        Deserializer des = this.desMap.get(key);
        if (des == null) {
            throw new IllegalArgumentException("No deserializer found for: " + key);
        }
        return des;
    }

    @Override
    public final Deserializer getDeserializer(SerializedDataType type) {
        Contract.requireArgNotNull((String)"type", (Object)((Object)type));
        EnhancedMimeType contentType = this.contentTypes.get((Object)type);
        if (contentType == null) {
            throw new IllegalArgumentException("No default content type was set for: " + type);
        }
        Key key = new Key(type, contentType.getBaseType());
        Deserializer des = this.desMap.get(key);
        if (des == null) {
            throw new IllegalArgumentException("No deserializer found for: " + key);
        }
        return des;
    }

    @Override
    public final EnhancedMimeType getDefaultContentType(SerializedDataType type) {
        Contract.requireArgNotNull((String)"type", (Object)((Object)type));
        EnhancedMimeType contentType = this.contentTypes.get((Object)type);
        if (contentType == null) {
            return null;
        }
        return contentType;
    }

    @Override
    public final boolean serializerExists(SerializedDataType type) {
        Serializer ser = this.serMap.get((Object)type);
        return ser != null;
    }

    @Override
    public final boolean deserializerExists(SerializedDataType type) {
        Contract.requireArgNotNull((String)"type", (Object)((Object)type));
        EnhancedMimeType contentType = this.contentTypes.get((Object)type);
        if (contentType == null) {
            throw new IllegalArgumentException("No default content type was set for: " + type);
        }
        Key key = new Key(type, contentType.getBaseType());
        Deserializer des = this.desMap.get(key);
        return des != null;
    }

    @Override
    public final boolean deserializerExists(SerializedDataType type, EnhancedMimeType mimeType) {
        Contract.requireArgNotNull((String)"type", (Object)((Object)type));
        Contract.requireArgNotNull((String)"mimeType", (Object)((Object)mimeType));
        Key key = new Key(type, mimeType.getBaseType());
        Deserializer des = this.desMap.get(key);
        return des != null;
    }

    private static class Key {
        private final SerializedDataType type;
        private final String contentType;

        public Key(SerializedDataType type, String contentType) {
            this.type = type;
            this.contentType = contentType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.contentType == null ? 0 : this.contentType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            if (this.type == null ? other.type != null : !this.type.equals((Object)other.type)) {
                return false;
            }
            return !(this.contentType == null ? other.contentType != null : !this.contentType.equals(other.contentType));
        }

        public String toString() {
            return "Key [type=" + this.type + ", contentType=" + this.contentType + "]";
        }
    }
}

