/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class AbstractPersistenceTest {
    private static EntityManagerFactory emf;
    private static EntityManager em;
    private static Connection connection;

    @BeforeClass
    public static void beforeClass() throws Exception {
        try {
            emf = Persistence.createEntityManagerFactory((String)"testPU");
            em = emf.createEntityManager();
            Map props = emf.getProperties();
            boolean shutdown = Boolean.valueOf("" + props.get("units4j.shutdown"));
            if (shutdown) {
                String connUrl = "" + props.get("units4j.url");
                String connUsername = "" + props.get("units4j.user");
                String connPassword = "" + props.get("units4j.pw");
                connection = DriverManager.getConnection(connUrl, connUsername, connPassword);
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @AfterClass
    public static void afterClass() {
        block10: {
            if (em != null) {
                em.close();
            }
            if (emf != null) {
                emf.close();
            }
            try {
                if (connection == null) break block10;
                try (Statement stmt = connection.createStatement();){
                    stmt.execute("SHUTDOWN");
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected static EntityManager getEm() {
        if (em == null) {
            throw new IllegalStateException("Entity manager not available - Something went wrong...");
        }
        return em;
    }

    protected static void beginTransaction() {
        AbstractPersistenceTest.getEm().getTransaction().begin();
    }

    protected static void commitTransaction() {
        AbstractPersistenceTest.getEm().getTransaction().commit();
    }

    protected static void rollbackTransaction() {
        if (AbstractPersistenceTest.getEm().getTransaction().isActive()) {
            AbstractPersistenceTest.getEm().getTransaction().rollback();
        }
    }
}

