/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fuin.units4j.TestOmitted;
import org.fuin.utils4j.Utils4J;
import org.fuin.utils4j.fileprocessor.FileHandler;
import org.fuin.utils4j.fileprocessor.FileHandlerResult;
import org.fuin.utils4j.fileprocessor.FileProcessor;
import org.junit.Assert;
import org.junit.Test;

public final class AssertCoverage {
    private AssertCoverage() {
        throw new UnsupportedOperationException("This utility class is not intended to be instanciated!");
    }

    public static final void assertEveryClassHasATest(Set<Class<?>> classes) {
        Utils4J.checkNotNull((String)"classes", classes);
        StringBuilder sb = new StringBuilder();
        for (Class<?> clasz : classes) {
            String testClassName = clasz.getName() + "Test";
            try {
                Class<?> testClass = Class.forName(testClassName);
                if (AssertCoverage.hasTestMethod(testClass)) continue;
                sb.append("\nThe test class '" + testClassName + "' contains no methods annotated with @Test");
            }
            catch (ClassNotFoundException ex) {
                sb.append("\nNo test class found for '" + clasz.getName() + "'");
            }
        }
        if (sb.length() > 0) {
            Assert.fail((String)sb.toString());
        }
    }

    public static final void assertEveryClassHasATest(File baseDir) {
        AssertCoverage.assertEveryClassHasATest(baseDir, new ClassFilter(){

            @Override
            public final boolean isIncludeClass(Class<?> clasz) {
                return true;
            }
        });
    }

    public static final void assertEveryClassHasATest(File baseDir, ClassFilter classFilter) {
        AssertCoverage.assertEveryClassHasATest(baseDir, true, classFilter);
    }

    public static final void assertEveryClassHasATest(File baseDir, boolean recursive) {
        AssertCoverage.assertEveryClassHasATest(baseDir, recursive, new ClassFilter(){

            @Override
            public final boolean isIncludeClass(Class<?> clasz) {
                return true;
            }
        });
    }

    public static final void assertEveryClassHasATest(File baseDir, boolean recursive, ClassFilter classFilter) {
        Utils4J.checkNotNull((String)"baseDir", (Object)baseDir);
        HashSet classes = new HashSet();
        AssertCoverage.analyzeDir(classes, baseDir, baseDir, recursive, classFilter);
        AssertCoverage.assertEveryClassHasATest(classes);
    }

    static void analyzeDir(final Set<Class<?>> classes, final File baseDir, File srcDir, final boolean recursive, final ClassFilter classFilter) {
        FileProcessor fileProcessor = new FileProcessor(new FileHandler(){

            public final FileHandlerResult handleFile(File file) {
                String simpleName;
                String packageName;
                String className;
                Class<?> clasz;
                if (file.isDirectory()) {
                    if (recursive) {
                        return FileHandlerResult.CONTINUE;
                    }
                    return FileHandlerResult.SKIP_SUBDIRS;
                }
                String name = file.getName();
                if (name.endsWith(".java") && !name.equals("package-info.java") && AssertCoverage.isInclude(clasz = AssertCoverage.classForName(className = (packageName = Utils4J.getRelativePath((File)baseDir, (File)file.getParentFile()).replace(File.separatorChar, '.')) + "." + (simpleName = name.substring(0, name.length() - 5))), classFilter)) {
                    classes.add(clasz);
                }
                return FileHandlerResult.CONTINUE;
            }
        });
        fileProcessor.process(srcDir);
    }

    private static Class<?> classForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    static boolean isInclude(Class<?> clasz, ClassFilter classFilter) {
        int modifiers = clasz.getModifiers();
        return classFilter.isIncludeClass(clasz) && !clasz.isAnnotation() && !clasz.isEnum() && !clasz.isInterface() && !Modifier.isAbstract(modifiers);
    }

    static boolean hasTestMethod(Class<?> testClass) {
        Method[] methods;
        if (testClass.getAnnotation(TestOmitted.class) != null) {
            return true;
        }
        boolean found = false;
        for (Method method : methods = testClass.getMethods()) {
            Test testAnnotation = method.getAnnotation(Test.class);
            if (testAnnotation == null) continue;
            found = true;
            break;
        }
        return found;
    }

    public static class AndClassFilter
    implements ClassFilter {
        private final ClassFilter[] classFilters;

        public AndClassFilter(ClassFilter ... classFilters) {
            if (classFilters == null) {
                throw new IllegalArgumentException("Argument 'classFilters' cannot be null");
            }
            if (classFilters.length < 2) {
                throw new IllegalArgumentException("Argument 'classFilters' is less than two: " + classFilters.length);
            }
            this.classFilters = classFilters;
        }

        @Override
        public final boolean isIncludeClass(Class<?> clasz) {
            for (ClassFilter classFilter : this.classFilters) {
                if (classFilter.isIncludeClass(clasz)) continue;
                return false;
            }
            return true;
        }
    }

    public static class ExcludeListClassFilter
    implements ClassFilter {
        private final List<Class<?>> excludedClasses = new ArrayList();

        public ExcludeListClassFilter(String ... fqClassNames) {
            if (fqClassNames != null) {
                for (String className : fqClassNames) {
                    Class<?> clasz = AssertCoverage.classForName(className);
                    this.excludedClasses.add(clasz);
                }
            }
        }

        public ExcludeListClassFilter(Class<?> ... excludedClasses) {
            if (excludedClasses != null) {
                for (Class<?> clasz : excludedClasses) {
                    this.excludedClasses.add(clasz);
                }
            }
        }

        @Override
        public final boolean isIncludeClass(Class<?> clasz) {
            return !this.excludedClasses.contains(clasz);
        }
    }

    public static interface ClassFilter {
        public boolean isIncludeClass(Class<?> var1);
    }
}

