/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.List;
import org.fuin.units4j.analyzer.MCAMethod;
import org.fuin.units4j.analyzer.MCAMethodCall;
import org.fuin.units4j.analyzer.MethodCallAnalyzer;
import org.fuin.utils4j.Utils4J;
import org.junit.Assert;

public final class AssertUsage {
    private AssertUsage() {
        throw new UnsupportedOperationException("This utility class is not intended to be instanciated!");
    }

    public static final void assertMethodsNotUsed(File classesDir, FileFilter filter, MCAMethod ... methodsToFind) {
        Utils4J.checkNotNull((String)"methodsToFind", (Object)methodsToFind);
        AssertUsage.assertMethodsNotUsed(classesDir, filter, Arrays.asList(methodsToFind));
    }

    public static final void assertMethodsNotUsed(File classesDir, FileFilter filter, List<MCAMethod> methodsToFind) {
        Utils4J.checkNotNull((String)"classesDir", (Object)classesDir);
        Utils4J.checkValidDir((File)classesDir);
        Utils4J.checkNotNull((String)"methodsToFind", methodsToFind);
        MethodCallAnalyzer analyzer = new MethodCallAnalyzer(methodsToFind);
        analyzer.findCallingMethodsInDir(classesDir, filter);
        List<MCAMethodCall> methodCalls = analyzer.getMethodCalls();
        if (!methodCalls.isEmpty()) {
            StringBuilder sb = new StringBuilder("Illegal method call(s) found:");
            for (MCAMethodCall methodCall : methodCalls) {
                sb.append("\n");
                sb.append(methodCall);
            }
            Assert.fail((String)sb.toString());
        }
    }
}

