/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j;

import org.fuin.units4j.AssertionResult;
import org.fuin.units4j.AssertionRule;

public final class AssertionRules<T>
implements AssertionRule<T> {
    private final AssertionRule<T>[] rules;

    @SafeVarargs
    public AssertionRules(AssertionRule<T> ... rules) {
        if (rules.length == 0) {
            throw new IllegalArgumentException("Argument 'rules' cannot be an empty array");
        }
        for (AssertionRule<T> rule : rules) {
            if (rule != null) continue;
            throw new IllegalArgumentException("Argument 'rules' cannot contain null elements");
        }
        this.rules = rules;
    }

    @Override
    public final AssertionResult verify(T obj) {
        boolean ok = true;
        StringBuilder sb = new StringBuilder();
        for (AssertionRule<T> rule : this.rules) {
            AssertionResult result = rule.verify(obj);
            if (result.isValid()) continue;
            ok = false;
            String msg = result.getErrorMessage();
            sb.append(msg);
            if (msg.endsWith("\n")) continue;
            sb.append("\n");
        }
        if (ok) {
            return AssertionResult.OK;
        }
        return new AssertionResult(sb.toString());
    }
}

