/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.assertj.core.api.AbstractAssert;
import org.fuin.units4j.AssertionResult;
import org.fuin.units4j.AssertionRules;
import org.fuin.units4j.assertionrules.RuleClassHasNoFinalMethods;
import org.fuin.units4j.assertionrules.RuleClassNotFinal;
import org.fuin.units4j.assertionrules.RuleJsonbFieldNotFinal;
import org.fuin.units4j.assertionrules.RuleMethodHasNullabilityInfo;
import org.fuin.units4j.assertionrules.RulePersistentInstanceFieldVisibility;
import org.fuin.units4j.assertionrules.RulePublicOrProtectedNoArgConstructor;
import org.fuin.units4j.assertionrules.Utils;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;

public final class JandexAssert
extends AbstractAssert<JandexAssert, Index> {
    private static final int SYNTHETIC = 4096;
    private static final int BRIDGE = 64;

    public JandexAssert(Index actual) {
        super((Object)actual, JandexAssert.class);
    }

    public static JandexAssert assertThat(Index actual) {
        return new JandexAssert(actual);
    }

    public JandexAssert hasOnlyValidJpaEntities() {
        this.isNotNull();
        ArrayList annotations = new ArrayList();
        annotations.addAll(((Index)this.actual).getAnnotations(DotName.createSimple((String)Entity.class.getName())));
        annotations.addAll(((Index)this.actual).getAnnotations(DotName.createSimple((String)MappedSuperclass.class.getName())));
        for (AnnotationInstance ai : annotations) {
            AnnotationTarget target = ai.target();
            ClassInfo info = target.asClass();
            AssertionRules<ClassInfo> rules = new AssertionRules<ClassInfo>(new RulePublicOrProtectedNoArgConstructor(), new RuleClassNotFinal(), new RuleClassHasNoFinalMethods(), new RulePersistentInstanceFieldVisibility());
            AssertionResult result = rules.verify(info);
            if (result.isValid()) continue;
            this.failWithMessage(result.getErrorMessage(), new Object[0]);
        }
        return this;
    }

    public JandexAssert hasNullabilityInfoOnAllMethods() {
        return this.hasNullabilityInfoOnAllMethods(new RuleMethodHasNullabilityInfo());
    }

    public JandexAssert hasNullabilityInfoOnAllMethods(RuleMethodHasNullabilityInfo rule) {
        this.isNotNull();
        StringBuilder sb = new StringBuilder();
        boolean ok = true;
        Collection classes = ((Index)this.actual).getKnownClasses();
        for (ClassInfo clasz : classes) {
            List methods = clasz.methods();
            for (MethodInfo method : methods) {
                AssertionResult result;
                List<MethodInfo> overrideMethods;
                if (this.ignored(method) || Modifier.isPrivate(method.flags()) || !(overrideMethods = Utils.findOverrideMethods((Index)this.actual, method)).isEmpty() || (result = rule.verify(method)).isValid()) continue;
                ok = false;
                sb.append(result.getErrorMessage());
            }
        }
        if (!ok) {
            this.failWithMessage("A parameter or the return value has neither a @NotNull/@NonNull nor a @Nullable annotation:\n" + sb.toString(), new Object[0]);
        }
        return this;
    }

    public JandexAssert hasNoFinalFieldsWithJsonbPropertyAnnotation() {
        this.isNotNull();
        RuleJsonbFieldNotFinal rule = new RuleJsonbFieldNotFinal();
        StringBuilder sb = new StringBuilder();
        boolean ok = true;
        Collection classes = ((Index)this.actual).getKnownClasses();
        for (ClassInfo clasz : classes) {
            List fields = clasz.fields();
            for (FieldInfo field : fields) {
                AssertionResult result = rule.verify(field);
                if (result.isValid()) continue;
                ok = false;
                sb.append(result.getErrorMessage());
            }
        }
        if (!ok) {
            this.failWithMessage("At least one field has a 'final' modifier and is annotated with '@JsonbProperty' at the same time:\n" + sb.toString(), new Object[0]);
        }
        return this;
    }

    private boolean ignored(MethodInfo method) {
        if (this.isSynthetic(method.flags()) || this.isBridge(method.flags())) {
            return true;
        }
        if (method.name().startsWith("access$")) {
            return true;
        }
        if (method.name().equals("equals") && method.parameters().size() == 1) {
            return true;
        }
        if (method.name().equals("compareTo") && method.parameters().size() == 1) {
            return true;
        }
        if (method.name().equals("toString") && method.parameters().isEmpty()) {
            return true;
        }
        if (method.declaringClass().superName().toString().equals(Enum.class.getName())) {
            if (method.name().equals("values")) {
                return true;
            }
            if (method.name().equals("valueOf") && method.parameters().size() == 1) {
                return true;
            }
        }
        if (method.declaringClass().name().toString().contains("$") && method.name().equals("get") && method.parameters().isEmpty()) {
            return true;
        }
        return method.declaringClass().name().toString().contains("$") && method.name().equals("<init>") && method.declaringClass().flags() == 32;
    }

    private boolean isSynthetic(short flags) {
        return (flags & 0x1000) > 0;
    }

    private boolean isBridge(short flags) {
        return (flags & 0x40) > 0;
    }
}

