/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.fuin.utils4j.JaxbUtils;
import org.fuin.utils4j.Utils4J;
import org.fuin.utils4j.fileprocessor.FileHandler;
import org.fuin.utils4j.fileprocessor.FileHandlerResult;
import org.fuin.utils4j.fileprocessor.FileProcessor;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;

public final class Units4JUtils {
    public static final String XML_PREFIX = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>";

    private Units4JUtils() {
        throw new UnsupportedOperationException("It's not allowed to create an instance of a utility class");
    }

    @Deprecated
    public static byte[] serialize(Object obj) {
        return Utils4J.serialize((Object)obj);
    }

    @Deprecated
    public static <T> T deserialize(byte[] data) {
        return (T)Utils4J.deserialize((byte[])data);
    }

    @Deprecated
    public static <T> String marshal(T data, Class<?> ... classesToBeBound) {
        return JaxbUtils.marshal(data, (Class[])classesToBeBound);
    }

    @Deprecated
    public static <T> String marshal(T data, XmlAdapter<?, ?>[] adapters, Class<?> ... classesToBeBound) {
        return JaxbUtils.marshal(data, adapters, (Class[])classesToBeBound);
    }

    @Deprecated
    public static <T> String marshal(@NotNull JAXBContext ctx, T data) {
        return JaxbUtils.marshal((Object)Units4JUtils.marshal(ctx, data), (Class[])new Class[0]);
    }

    @Deprecated
    public static <T> String marshal(@NotNull JAXBContext ctx, T data, XmlAdapter<?, ?>[] adapters) {
        return JaxbUtils.marshal((JAXBContext)ctx, data, adapters);
    }

    @Deprecated
    public static <T> T unmarshal(String xmlData, Class<?> ... classesToBeBound) {
        return (T)JaxbUtils.unmarshal((String)xmlData, (Class[])classesToBeBound);
    }

    @Deprecated
    public static <T> T unmarshal(String xmlData, XmlAdapter<?, ?>[] adapters, Class<?> ... classesToBeBound) {
        return (T)JaxbUtils.unmarshal((String)xmlData, adapters, (Class[])classesToBeBound);
    }

    @Deprecated
    public static <T> T unmarshal(@NotNull JAXBContext ctx, String xmlData, XmlAdapter<?, ?>[] adapters) {
        return (T)JaxbUtils.unmarshal((JAXBContext)ctx, (String)xmlData, adapters);
    }

    public static void setPrivateField(Object obj, String name, Object value) {
        try {
            Field field = obj.getClass().getDeclaredField(name);
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (Exception ex) {
            throw new RuntimeException("Couldn't set field '" + name + "' in class '" + obj.getClass() + "'", ex);
        }
    }

    public static void assertCauseMessage(Throwable ex, String expectedMessage) {
        Assertions.assertThat((Throwable)ex.getCause()).isNotNull();
        Assertions.assertThat((String)ex.getCause().getMessage()).isEqualTo(expectedMessage);
    }

    public static void assertCauseCauseMessage(Throwable ex, String expectedMessage) {
        Assertions.assertThat((Throwable)ex.getCause()).isNotNull();
        Assertions.assertThat((Throwable)ex.getCause().getCause()).isNotNull();
        Assertions.assertThat((String)ex.getCause().getCause().getMessage()).isEqualTo(expectedMessage);
    }

    public static Set<ConstraintViolation<Object>> validate(Object obj, Class<?> ... scopes) {
        if (scopes == null) {
            return Units4JUtils.validator().validate(obj, new Class[]{Default.class});
        }
        return Units4JUtils.validator().validate(obj, (Class[])scopes);
    }

    public static Validator validator() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        return factory.getValidator();
    }

    public static List<File> findFilesRecursive(File dir, String extension) {
        final String dotExtension = "." + extension;
        final ArrayList<File> files = new ArrayList<File>();
        FileProcessor fileProcessor = new FileProcessor(new FileHandler(){

            public final FileHandlerResult handleFile(File file) {
                if (file.isDirectory()) {
                    return FileHandlerResult.CONTINUE;
                }
                String name = file.getName();
                if (name.endsWith(dotExtension)) {
                    files.add(file);
                }
                return FileHandlerResult.CONTINUE;
            }
        });
        fileProcessor.process(dir);
        return files;
    }

    public static List<File> findAllClasses(File dir) {
        return Units4JUtils.findFilesRecursive(dir, "class");
    }

    public static final Index indexAllClasses(List<File> classFiles) {
        Indexer indexer = new Indexer();
        Units4JUtils.indexAllClasses(indexer, classFiles);
        return indexer.complete();
    }

    public static final void indexAllClasses(Indexer indexer, List<File> classFiles) {
        classFiles.forEach(file -> {
            try (FileInputStream in = new FileInputStream((File)file);){
                indexer.index((InputStream)in);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public static ClassInfo classInfo(Class<?> clasz) {
        return Units4JUtils.classInfo(Units4JUtils.class.getClassLoader(), clasz);
    }

    public static ClassInfo classInfo(ClassLoader cl, Class<?> clasz) {
        return Units4JUtils.classInfo(cl, clasz.getName());
    }

    public static ClassInfo classInfo(String className) {
        return Units4JUtils.classInfo(Units4JUtils.class.getClassLoader(), className);
    }

    public static ClassInfo classInfo(ClassLoader cl, String className) {
        Index index = Units4JUtils.index(cl, className);
        return index.getClassByName(DotName.createSimple((String)className));
    }

    public static Index index(ClassLoader cl, String className) {
        Indexer indexer = new Indexer();
        Units4JUtils.index(indexer, cl, className);
        return indexer.complete();
    }

    public static void index(Indexer indexer, ClassLoader cl, String className) {
        InputStream stream = cl.getResourceAsStream(className.replace('.', '/') + ".class");
        try {
            indexer.index(stream);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String replaceXmlAttr(String xml, KV ... keyValues) {
        ArrayList<String> searchList = new ArrayList<String>();
        ArrayList<CallSite> replacementList = new ArrayList<CallSite>();
        for (KV kv : keyValues) {
            String tag = kv.getKey() + "=\"";
            int pa = xml.indexOf(tag);
            while (pa > -1) {
                int s = pa + tag.length();
                int pe = xml.indexOf("\"", s);
                if (pe > -1) {
                    String str = xml.substring(pa, pe + 1);
                    searchList.add(str);
                    String repl = xml.substring(pa, pa + tag.length()) + kv.getValue() + "\"";
                    replacementList.add((CallSite)((Object)repl));
                }
                pa = xml.indexOf(tag, s);
            }
        }
        String[] searchArray = searchList.toArray(new String[searchList.size()]);
        String[] replacementArray = replacementList.toArray(new String[replacementList.size()]);
        return StringUtils.replaceEachRepeatedly((String)xml, (String[])searchArray, (String[])replacementArray);
    }

    public static boolean isExpectedType(Class<?> expectedClass, Object obj) {
        Class<?> actualClass = obj == null ? null : obj.getClass();
        return Objects.equals(expectedClass, actualClass);
    }

    public static boolean isExpectedException(Class<? extends Exception> expectedClass, String expectedMessage, Exception ex) {
        if (!Units4JUtils.isExpectedType(expectedClass, ex)) {
            return false;
        }
        if (expectedClass != null && expectedMessage != null && ex != null) {
            return Objects.equals(expectedMessage, ex.getMessage());
        }
        return true;
    }

    public static final class KV {
        private final String key;
        private final String value;

        public KV(@NotNull String key, @NotNull String value) {
            if (key == null) {
                throw new IllegalArgumentException("Key cannot be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("Value cannot be null");
            }
            this.key = key;
            this.value = value;
        }

        public final String getKey() {
            return this.key;
        }

        public final String getValue() {
            return this.value;
        }
    }
}

