/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j.analyzer;

import java.util.ArrayList;
import java.util.List;
import org.fuin.units4j.analyzer.EmptyClassVisitor;
import org.fuin.units4j.analyzer.MCAMethod;
import org.fuin.units4j.analyzer.MCAMethodCall;
import org.fuin.units4j.analyzer.MCAMethodVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public final class MCAClassVisitor
extends ClassVisitor {
    private final List<MCAMethodCall> calls;
    private final MCAMethodVisitor methodVisitor;
    private String source;
    private String className;
    private String methodName;
    private String methodDescr;

    public MCAClassVisitor(List<MCAMethod> methodsToFind) {
        super(458752, (ClassVisitor)new EmptyClassVisitor());
        if (methodsToFind == null) {
            throw new IllegalArgumentException("Argument 'methodsToFind' canot be NULL");
        }
        this.calls = new ArrayList<MCAMethodCall>();
        this.methodVisitor = new MCAMethodVisitor(this, methodsToFind);
    }

    public final void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
    }

    public final void visitSource(String source, String debug) {
        this.source = source;
    }

    public final MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.methodName = name;
        this.methodDescr = desc;
        return this.methodVisitor;
    }

    public final void addCall(MCAMethod found, int line) {
        this.calls.add(new MCAMethodCall(found, this.className, this.methodName, this.methodDescr, this.source, line));
    }

    public final List<MCAMethodCall> getMethodCalls() {
        return this.calls;
    }

    public final void clearMethodCalls() {
        this.calls.clear();
    }

    public final List<MCAMethod> getMethodsToFind() {
        return this.methodVisitor.getToFind();
    }

    public final String getSource() {
        return this.source;
    }

    public final String getClassName() {
        return this.className;
    }

    public final String getMethodName() {
        return this.methodName;
    }

    public final String getMethodDescr() {
        return this.methodDescr;
    }
}

