/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j.analyzer;

import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public final class MCAMethod
implements Comparable<MCAMethod> {
    private final String className;
    private final String methodSignature;
    private final Method method;

    public MCAMethod(String className, String methodSignature) {
        if (className == null) {
            throw new IllegalArgumentException("Argument 'className' canot be NULL");
        }
        if (methodSignature == null) {
            throw new IllegalArgumentException("Argument 'methodSignature' canot be NULL");
        }
        this.className = className;
        this.methodSignature = methodSignature;
        this.method = Method.getMethod((String)methodSignature);
    }

    public MCAMethod(String asmClassName, String asmMethodName, String asmMethodDescr) {
        if (asmClassName == null) {
            throw new IllegalArgumentException("Argument 'asmClassName' canot be NULL");
        }
        if (asmMethodName == null) {
            throw new IllegalArgumentException("Argument 'asmMethodName' canot be NULL");
        }
        if (asmMethodDescr == null) {
            throw new IllegalArgumentException("Argument 'asmMethodDescr' canot be NULL");
        }
        this.className = asmClassName.replace('/', '.');
        int p = asmMethodDescr.indexOf(41);
        if (p < 0) {
            throw new IllegalStateException("Couldn't find closing bracket: " + asmMethodDescr);
        }
        StringBuilder sb = new StringBuilder("(");
        Type[] argTypes = Type.getArgumentTypes((String)asmMethodDescr);
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(argTypes[i].getClassName());
            }
        }
        sb.append(")");
        String returnType = Type.getReturnType((String)asmMethodDescr).getClassName();
        this.methodSignature = returnType + " " + asmMethodName + sb;
        this.method = Method.getMethod((String)this.methodSignature);
    }

    public final String getClassName() {
        return this.className;
    }

    public final Method getMethod() {
        return this.method;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.methodSignature == null ? 0 : this.methodSignature.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MCAMethod other = (MCAMethod)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        return !(this.methodSignature == null ? other.methodSignature != null : !this.methodSignature.equals(other.methodSignature));
    }

    @Override
    public final int compareTo(MCAMethod other) {
        int i = this.className.compareTo(other.className);
        if (i != 0) {
            return i;
        }
        return this.methodSignature.compareTo(other.methodSignature);
    }

    public final String toString() {
        return "Class='" + this.className + ", Method='" + this.methodSignature + "'";
    }
}

