/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j.analyzer;

import java.util.List;
import org.fuin.units4j.analyzer.EmptyMethodVisitor;
import org.fuin.units4j.analyzer.MCAClassVisitor;
import org.fuin.units4j.analyzer.MCAMethod;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public final class MCAMethodVisitor
extends MethodVisitor {
    private final MCAClassVisitor classVisitor;
    private final List<MCAMethod> toFind;
    private MCAMethod found;
    private int line;

    public MCAMethodVisitor(MCAClassVisitor classVisitor, List<MCAMethod> toFind) {
        super(458752, (MethodVisitor)new EmptyMethodVisitor());
        if (classVisitor == null) {
            throw new IllegalArgumentException("Argument 'classVisitor' canot be NULL");
        }
        if (toFind == null) {
            throw new IllegalArgumentException("Argument 'toFind' canot be NULL");
        }
        this.classVisitor = classVisitor;
        this.toFind = toFind;
    }

    public final void visitMethodInsn(int opcode, String owner, String name, String descr, boolean itf) {
        MCAMethod m = new MCAMethod(owner, name, descr);
        int idx = this.toFind.indexOf(m);
        if (idx > -1) {
            this.found = this.toFind.get(idx);
        }
    }

    public final void visitCode() {
        this.found = null;
    }

    public final void visitLineNumber(int line, Label start) {
        this.line = line;
    }

    public final void visitEnd() {
        if (this.found != null) {
            this.classVisitor.addCall(this.found, this.line);
        }
    }

    public final boolean isFound() {
        return this.found != null;
    }

    public final MCAClassVisitor getClassVisitor() {
        return this.classVisitor;
    }

    public final List<MCAMethod> getToFind() {
        return this.toFind;
    }
}

