/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j.analyzer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.fuin.units4j.analyzer.MCAClassVisitor;
import org.fuin.units4j.analyzer.MCAMethod;
import org.fuin.units4j.analyzer.MCAMethodCall;
import org.fuin.utils4j.fileprocessor.FileHandler;
import org.fuin.utils4j.fileprocessor.FileHandlerResult;
import org.fuin.utils4j.fileprocessor.FileProcessor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public final class MethodCallAnalyzer {
    private MCAClassVisitor cv;

    public MethodCallAnalyzer(MCAMethod ... methodsToFind) {
        if (methodsToFind == null) {
            throw new IllegalArgumentException("Argument 'methodsToFind' cannot be null");
        }
        if (methodsToFind.length == 0) {
            throw new IllegalArgumentException("Argument 'methodsToFind' cannot be empty");
        }
        this.cv = new MCAClassVisitor(Arrays.asList(methodsToFind));
    }

    public MethodCallAnalyzer(List<MCAMethod> methodsToFind) {
        if (methodsToFind.size() == 0) {
            throw new IllegalArgumentException("Argument 'methodsToFind' cannot be empty");
        }
        this.cv = new MCAClassVisitor(methodsToFind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void findCallingMethodsInJar(File file) throws IOException {
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                try (BufferedInputStream in = new BufferedInputStream(jarFile.getInputStream(entry), 1024);){
                    new ClassReader((InputStream)in).accept((ClassVisitor)this.cv, 0);
                }
            }
        }
    }

    private void handleClass(File classFile) {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(classFile), 1024);){
            new ClassReader((InputStream)in).accept((ClassVisitor)this.cv, 0);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading: " + classFile, ex);
        }
    }

    public final void findCallingMethodsInDir(File dir) {
        this.findCallingMethodsInDir(dir, null);
    }

    public final void findCallingMethodsInDir(File dir, final FileFilter filter) {
        FileProcessor fileProcessor = new FileProcessor(new FileHandler(){

            public final FileHandlerResult handleFile(File file) {
                if (file.isDirectory()) {
                    return FileHandlerResult.CONTINUE;
                }
                if (file.getName().endsWith(".class") && (filter == null || filter.accept(file))) {
                    MethodCallAnalyzer.this.handleClass(file);
                }
                return FileHandlerResult.CONTINUE;
            }
        });
        fileProcessor.process(dir);
    }

    public List<MCAMethod> getMethodsToFind() {
        return this.cv.getMethodsToFind();
    }

    public final List<MCAMethodCall> getMethodCalls() {
        return this.cv.getMethodCalls();
    }

    public final void clearMethodCalls() {
        this.cv.clearMethodCalls();
    }
}

