/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j.assertionrules;

import java.lang.reflect.Modifier;
import java.util.List;
import org.fuin.units4j.AssertionResult;
import org.fuin.units4j.AssertionRule;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;

public final class RuleClassHasNoFinalMethods
implements AssertionRule<ClassInfo> {
    @Override
    public final AssertionResult verify(ClassInfo info) {
        boolean ok = true;
        StringBuilder sb = new StringBuilder("Class " + info.name() + " has final methods:\n");
        List methodInfos = info.methods();
        for (MethodInfo methodInfo : methodInfos) {
            if (!Modifier.isFinal(methodInfo.flags())) continue;
            ok = false;
            sb.append(methodInfo.toString());
            sb.append("\n");
        }
        if (ok) {
            return AssertionResult.OK;
        }
        return new AssertionResult(sb.toString());
    }
}

