/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j.assertionrules;

import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.fuin.units4j.AssertionResult;
import org.fuin.units4j.AssertionRule;
import org.fuin.units4j.assertionrules.Visibility;
import org.jboss.jandex.FieldInfo;

public final class RuleFieldVisibility
implements AssertionRule<FieldInfo> {
    private final Set<Visibility> allowed;

    public RuleFieldVisibility(Visibility ... allowed) {
        this.allowed = new HashSet<Visibility>();
        for (Visibility v : allowed) {
            this.allowed.add(v);
        }
    }

    public RuleFieldVisibility(Set<Visibility> allowed) {
        this.allowed = allowed;
    }

    @Override
    public final AssertionResult verify(FieldInfo info) {
        if (Modifier.isPublic(info.flags())) {
            if (this.allowed.contains((Object)Visibility.PUBLIC)) {
                return AssertionResult.OK;
            }
            return new AssertionResult("Public visibility is not allowed for: " + this.fqn(info));
        }
        if (Modifier.isProtected(info.flags())) {
            if (this.allowed.contains((Object)Visibility.PROTECTED)) {
                return AssertionResult.OK;
            }
            return new AssertionResult("Protected visibility is not allowed for: " + this.fqn(info));
        }
        if (Modifier.isPrivate(info.flags())) {
            if (this.allowed.contains((Object)Visibility.PRIVATE)) {
                return AssertionResult.OK;
            }
            return new AssertionResult("Private visibility is not allowed for: " + this.fqn(info));
        }
        if (!this.allowed.contains((Object)Visibility.PACKAGE)) {
            return new AssertionResult("Package-private visibility is not allowed for: " + this.fqn(info));
        }
        return AssertionResult.OK;
    }

    private String fqn(FieldInfo info) {
        return info.declaringClass().name() + "." + info.name();
    }
}

