/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j.assertionrules;

import java.lang.reflect.Modifier;
import java.util.List;
import org.fuin.units4j.AssertionResult;
import org.fuin.units4j.AssertionRule;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;

public final class RuleJsonbFieldNotFinal
implements AssertionRule<FieldInfo> {
    @Override
    public final AssertionResult verify(FieldInfo info) {
        if (Modifier.isFinal(info.flags()) && this.hasJsonbPropertyAnnotation(info.annotations())) {
            return new AssertionResult("Modifier 'final' is not allowed for field with '@JsonbProperty': " + this.fqn(info));
        }
        return AssertionResult.OK;
    }

    private boolean hasJsonbPropertyAnnotation(List<AnnotationInstance> annotations) {
        for (AnnotationInstance annotation : annotations) {
            if (annotation.name().compareTo(DotName.createSimple((String)"javax.json.bind.annotation.JsonbProperty")) != 0) continue;
            return true;
        }
        return false;
    }

    private String fqn(FieldInfo info) {
        return info.declaringClass().name() + "." + info.name();
    }
}

