/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j.assertionrules;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.fuin.units4j.AssertionResult;
import org.fuin.units4j.AssertionRule;
import org.fuin.units4j.assertionrules.Utils;
import org.fuin.utils4j.Utils4J;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public final class RuleMethodHasNullabilityInfo
implements AssertionRule<MethodInfo> {
    private final List<String> expectedAnnotations;
    private final DotName optionalDotName;

    public RuleMethodHasNullabilityInfo() {
        this("NotEmpty", "NotNull", "NonNull", "Nullable");
    }

    public RuleMethodHasNullabilityInfo(String ... annotationNames) {
        Utils4J.checkNotNull((String)"annotationNames", (Object)annotationNames);
        this.expectedAnnotations = Arrays.asList(annotationNames);
        this.optionalDotName = DotName.createSimple((String)Optional.class.getName());
    }

    @Override
    public final AssertionResult verify(@NotNull MethodInfo method) {
        Utils4J.checkNotNull((String)"method", (Object)method);
        StringBuilder sb = new StringBuilder();
        boolean returnTypeOk = this.validReturnType(method, sb);
        boolean parametersOk = this.validParameters(method, sb);
        if (returnTypeOk && parametersOk) {
            return AssertionResult.OK;
        }
        return new AssertionResult(sb.toString());
    }

    private boolean validParameters(MethodInfo method, StringBuilder sb) {
        boolean ok = true;
        Map<Integer, List<AnnotationInstance>> map = Utils.createParameterAnnotationMap(method);
        List params = method.parameters();
        for (int i = 0; i < params.size(); ++i) {
            List<AnnotationInstance> annotations;
            Type param = (Type)params.get(i);
            if (this.typeIsPrimitive(param) || this.typeIsOptional(param) || (annotations = map.get(i)) != null && Utils.hasOneOfSimpleAnnotations(annotations, this.expectedAnnotations)) continue;
            ok = false;
            sb.append(method.declaringClass());
            sb.append("\t");
            sb.append(method);
            sb.append("\t");
            sb.append("Parameter #" + i + " (" + ((Type)params.get(i)).name() + ")\n");
        }
        return ok;
    }

    private boolean validReturnType(MethodInfo method, StringBuilder sb) {
        List<AnnotationInstance> list;
        if (!(this.returnsVoid(method) || this.returnsPrimitive(method) || this.returnsOptional(method) || Utils.hasOneOfSimpleAnnotations(list = Utils.createReturnTypeAnnotationList(method), this.expectedAnnotations))) {
            sb.append(method.declaringClass());
            sb.append("\t");
            sb.append(method);
            sb.append("\t");
            sb.append("Return type (" + method.returnType() + ")\n");
            return false;
        }
        return true;
    }

    private boolean typeIsPrimitive(Type type) {
        return type.kind() == Type.Kind.PRIMITIVE;
    }

    private boolean typeIsOptional(Type type) {
        return type.name().equals((Object)this.optionalDotName);
    }

    private boolean returnsPrimitive(MethodInfo method) {
        return this.typeIsPrimitive(method.returnType());
    }

    private boolean returnsVoid(MethodInfo method) {
        return method.returnType().kind() == Type.Kind.VOID;
    }

    private boolean returnsOptional(MethodInfo method) {
        return this.typeIsOptional(method.returnType());
    }
}

