/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j.assertionrules;

import java.lang.reflect.Modifier;
import java.util.List;
import javax.persistence.Transient;
import org.fuin.units4j.AssertionResult;
import org.fuin.units4j.AssertionRule;
import org.fuin.units4j.assertionrules.RuleFieldVisibility;
import org.fuin.units4j.assertionrules.Utils;
import org.fuin.units4j.assertionrules.Visibility;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;

public final class RulePersistentInstanceFieldVisibility
implements AssertionRule<ClassInfo> {
    private final RuleFieldVisibility fieldRule = new RuleFieldVisibility(Visibility.PRIVATE, Visibility.PROTECTED, Visibility.PACKAGE);

    @Override
    public final AssertionResult verify(ClassInfo info) {
        StringBuilder sb = new StringBuilder();
        boolean ok = true;
        List fields = info.fields();
        for (FieldInfo field : fields) {
            AssertionResult fieldResult;
            if (Modifier.isStatic(field.flags()) || Modifier.isFinal(field.flags()) || Utils.hasAnnotation(field.annotations(), Transient.class.getName()) || (fieldResult = this.fieldRule.verify(field)).isValid()) continue;
            ok = false;
            sb.append(fieldResult.getErrorMessage());
            sb.append("\n");
        }
        if (ok) {
            return AssertionResult.OK;
        }
        return new AssertionResult(sb.toString());
    }
}

