/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j.assertionrules;

import java.lang.reflect.Modifier;
import org.fuin.units4j.AssertionResult;
import org.fuin.units4j.AssertionRule;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public final class RulePublicOrProtectedNoArgConstructor
implements AssertionRule<ClassInfo> {
    @Override
    public final AssertionResult verify(ClassInfo info) {
        MethodInfo method = info.method("<init>", new Type[0]);
        if (method == null || !this.publicOrProtected(method)) {
            return new AssertionResult("Missing public or protected no arg constructor: " + info.name());
        }
        return AssertionResult.OK;
    }

    private boolean publicOrProtected(MethodInfo method) {
        return Modifier.isPublic(method.flags()) || Modifier.isProtected(method.flags());
    }
}

