/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j.assertionrules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.fuin.utils4j.Utils4J;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public final class Utils {
    private Utils() {
        throw new UnsupportedOperationException("This utility class is not intended to be instanciated!");
    }

    public static boolean hasOneOfAnnotations(@NotNull List<AnnotationInstance> annotations, @NotNull List<String> annotationClaszNames) {
        for (String annotationClaszName : annotationClaszNames) {
            if (!Utils.hasAnnotation(annotations, annotationClaszName)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnnotation(@NotNull List<AnnotationInstance> annotations, @NotNull String annotationClaszName) {
        Utils4J.checkNotNull((String)"annotations", annotations);
        Utils4J.checkNotNull((String)"annotationClaszName", (Object)annotationClaszName);
        DotName annotationName = DotName.createSimple((String)annotationClaszName);
        for (AnnotationInstance annotation : annotations) {
            if (!annotation.name().equals((Object)annotationName)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOneOfSimpleAnnotations(@NotNull List<AnnotationInstance> annotations, @NotNull List<String> annotationClaszNames) {
        for (String annotationClaszName : annotationClaszNames) {
            if (!Utils.hasSimpleAnnotation(annotations, annotationClaszName)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSimpleAnnotation(@NotNull List<AnnotationInstance> annotations, @NotNull String annotationClaszName) {
        Utils4J.checkNotNull((String)"annotations", annotations);
        Utils4J.checkNotNull((String)"annotationClaszName", (Object)annotationClaszName);
        String annotationName = Utils.simpleName(DotName.createSimple((String)annotationClaszName));
        for (AnnotationInstance annotation : annotations) {
            if (!annotationName.equalsIgnoreCase(Utils.simpleName(annotation.name()))) continue;
            return true;
        }
        return false;
    }

    public static Map<Integer, List<AnnotationInstance>> createParameterAnnotationMap(@NotNull MethodInfo method) {
        Utils4J.checkNotNull((String)"method", (Object)method);
        HashMap<Integer, List<AnnotationInstance>> result = new HashMap<Integer, List<AnnotationInstance>>();
        List parameters = method.parameters();
        for (int i = 0; i < parameters.size(); ++i) {
            if (((Type)parameters.get(i)).kind() == Type.Kind.ARRAY) {
                result.put(i, ((Type)parameters.get(i)).asArrayType().component().annotations());
                continue;
            }
            result.put(i, ((Type)parameters.get(i)).annotations());
        }
        return result;
    }

    public static List<AnnotationInstance> createReturnTypeAnnotationList(@NotNull MethodInfo method) {
        Utils4J.checkNotNull((String)"method", (Object)method);
        ArrayList<AnnotationInstance> result = new ArrayList<AnnotationInstance>();
        if (method.returnType().kind() != Type.Kind.VOID) {
            List annotations = method.returnType().kind() == Type.Kind.ARRAY ? method.returnType().asArrayType().component().annotations() : method.returnType().annotations();
            for (AnnotationInstance ai : annotations) {
                result.add(ai);
            }
        }
        return result;
    }

    public static List<MethodInfo> findOverrideMethods(@NotNull Index index, @NotNull MethodInfo method) {
        Utils4J.checkNotNull((String)"index", (Object)index);
        Utils4J.checkNotNull((String)"method", (Object)method);
        return Utils.findOverrideMethods(index, method.declaringClass(), method, 0);
    }

    public static String simpleName(DotName dotName) {
        String name = dotName.withoutPackagePrefix();
        int p = name.indexOf(36);
        if (p > -1) {
            return name.substring(p + 1);
        }
        return dotName.withoutPackagePrefix();
    }

    private static List<MethodInfo> findOverrideMethods(@NotNull Index index, ClassInfo clasz, @NotNull MethodInfo methodToFind, int level) {
        Utils4J.checkNotNull((String)"index", (Object)index);
        Utils4J.checkNotNull((String)"methodToFind", (Object)methodToFind);
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        if (clasz != null) {
            if (level > 0) {
                Utils.addIfFound(clasz, methodToFind, methods);
            }
            methods.addAll(Utils.findInterfaceMethods(index, clasz, methodToFind));
            DotName superName = clasz.superName();
            ClassInfo superClass = index.getClassByName(superName);
            methods.addAll(Utils.findOverrideMethods(index, superClass, methodToFind, level + 1));
        }
        return methods;
    }

    private static List<MethodInfo> findInterfaceMethods(@NotNull Index index, ClassInfo clasz, @NotNull MethodInfo methodToFind) {
        Utils4J.checkNotNull((String)"index", (Object)index);
        Utils4J.checkNotNull((String)"methodToFind", (Object)methodToFind);
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        if (clasz != null) {
            List interfaceNames = clasz.interfaceNames();
            for (DotName interfaceName : interfaceNames) {
                ClassInfo intf = index.getClassByName(interfaceName);
                Utils.addIfFound(intf, methodToFind, methods);
                methods.addAll(Utils.findInterfaceMethods(index, intf, methodToFind));
            }
        }
        return methods;
    }

    private static void addIfFound(ClassInfo clasz, MethodInfo methodToFind, List<MethodInfo> methods) {
        MethodInfo foundMethod;
        if (clasz != null && (foundMethod = clasz.method(methodToFind.name(), methodToFind.parameters().toArray(new Type[methodToFind.parameters().size()]))) != null) {
            methods.add(foundMethod);
        }
    }
}

