/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j.dependency;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.fuin.units4j.dependency.DependsOn;
import org.fuin.units4j.dependency.InvalidDependenciesDefinitionException;
import org.fuin.units4j.dependency.NotDependsOn;
import org.fuin.units4j.dependency.Package;
import org.fuin.units4j.dependency.Utils;

@XmlRootElement(name="dependencies")
public final class Dependencies
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElementWrapper(name="alwaysAllowed")
    @XmlElement(name="dependsOn")
    private final List<DependsOn> alwaysAllowed = new ArrayList<DependsOn>();
    @XmlElementWrapper(name="alwaysForbidden")
    @XmlElement(name="notDependsOn")
    private final List<NotDependsOn> alwaysForbidden = new ArrayList<NotDependsOn>();
    @XmlElementWrapper(name="allowed")
    @XmlElement(name="package")
    private final List<Package<DependsOn>> allowed = new ArrayList<Package<DependsOn>>();
    @XmlElementWrapper(name="forbidden")
    @XmlElement(name="package")
    private final List<Package<NotDependsOn>> forbidden = new ArrayList<Package<NotDependsOn>>();

    public final List<DependsOn> getAlwaysAllowed() {
        if (this.alwaysAllowed == null) {
            return Collections.emptyList();
        }
        return this.alwaysAllowed;
    }

    public final List<NotDependsOn> getAlwaysForbidden() {
        if (this.alwaysForbidden == null) {
            return Collections.emptyList();
        }
        return this.alwaysForbidden;
    }

    public final boolean isAlwaysAllowed(String packageName) {
        if (packageName.equals("java.lang")) {
            return true;
        }
        return Utils.findAllowedByName(this.getAlwaysAllowed(), packageName) != null;
    }

    public final boolean isAlwaysForbidden(String packageName) {
        return Utils.findForbiddenByName(this.getAlwaysForbidden(), packageName) != null;
    }

    public final List<Package<DependsOn>> getAllowed() {
        if (this.allowed == null) {
            return Collections.emptyList();
        }
        return this.allowed;
    }

    public final List<Package<NotDependsOn>> getForbidden() {
        if (this.forbidden == null) {
            return Collections.emptyList();
        }
        return this.forbidden;
    }

    public final void validate() throws InvalidDependenciesDefinitionException {
        int errorCount = 0;
        StringBuilder sb = new StringBuilder("Duplicate package entries in 'allowed' and 'forbidden': ");
        List<Package<NotDependsOn>> list = this.getForbidden();
        for (int i = 0; i < list.size(); ++i) {
            String name = list.get(i).getName();
            Package dep = new Package(name);
            if (this.getAllowed().indexOf(dep) <= -1) continue;
            if (errorCount > 0) {
                sb.append(", ");
            }
            sb.append(name);
            ++errorCount;
        }
        if (errorCount > 0) {
            throw new InvalidDependenciesDefinitionException(this, sb.toString());
        }
    }

    public final Package<DependsOn> findAllowedByName(String packageName) {
        List<Package<DependsOn>> list = this.getAllowed();
        for (Package<DependsOn> pkg : list) {
            if (!pkg.getName().equals(packageName)) continue;
            return pkg;
        }
        return null;
    }

    public final Package<NotDependsOn> findForbiddenByName(String packageName) {
        List<Package<NotDependsOn>> list = this.getForbidden();
        for (Package<NotDependsOn> pkg : list) {
            if (!pkg.getName().equals(packageName)) continue;
            return pkg;
        }
        return null;
    }
}

