/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j.dependency;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fuin.units4j.dependency.Dependencies;
import org.fuin.units4j.dependency.DependencyError;
import org.fuin.units4j.dependency.DependencyVisitor;
import org.fuin.units4j.dependency.DependsOn;
import org.fuin.units4j.dependency.InvalidDependenciesDefinitionException;
import org.fuin.units4j.dependency.NotDependsOn;
import org.fuin.units4j.dependency.Package;
import org.fuin.units4j.dependency.Utils;
import org.fuin.utils4j.Utils4J;
import org.fuin.utils4j.fileprocessor.FileHandler;
import org.fuin.utils4j.fileprocessor.FileHandlerResult;
import org.fuin.utils4j.fileprocessor.FileProcessor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public final class DependencyAnalyzer {
    private final List<DependencyError> dependencyErrors;
    private final Dependencies dependencies;

    public DependencyAnalyzer(File dependenciesFile) throws InvalidDependenciesDefinitionException {
        this(Utils.load(dependenciesFile));
    }

    public DependencyAnalyzer(Class<?> clasz, String dependenciesFilePathAndName) throws InvalidDependenciesDefinitionException {
        this(Utils.load(clasz, dependenciesFilePathAndName));
    }

    public DependencyAnalyzer(Dependencies dependencies) throws InvalidDependenciesDefinitionException {
        Utils4J.checkNotNull((String)"dependencies", (Object)dependencies);
        this.dependencies = dependencies;
        this.dependencies.validate();
        this.dependencyErrors = new ArrayList<DependencyError>();
    }

    private List<DependencyError> checkAllowedSection(Dependencies dependencies, Package<DependsOn> allowedPkg, ClassInfo classInfo) {
        ArrayList<DependencyError> errors = new ArrayList<DependencyError>();
        for (String importedPkg : classInfo.getImports()) {
            DependsOn dep;
            if (importedPkg.equals(allowedPkg.getName()) || dependencies.isAlwaysAllowed(importedPkg) || (dep = Utils.findAllowedByName(allowedPkg.getDependencies(), importedPkg)) != null) continue;
            errors.add(new DependencyError(classInfo.getName(), importedPkg, allowedPkg.getComment()));
        }
        return errors;
    }

    private static List<DependencyError> checkForbiddenSection(Dependencies dependencies, Package<NotDependsOn> forbiddenPkg, ClassInfo classInfo) {
        ArrayList<DependencyError> errors = new ArrayList<DependencyError>();
        for (String importedPkg : classInfo.getImports()) {
            if (importedPkg.equals(classInfo.getPackageName())) continue;
            NotDependsOn ndo = Utils.findForbiddenByName(dependencies.getAlwaysForbidden(), importedPkg);
            if (ndo != null) {
                errors.add(new DependencyError(classInfo.getName(), importedPkg, ndo.getComment()));
                continue;
            }
            NotDependsOn dep = Utils.findForbiddenByName(forbiddenPkg.getDependencies(), importedPkg);
            if (dep == null) continue;
            String comment = dep.getComment() == null ? forbiddenPkg.getComment() : dep.getComment();
            errors.add(new DependencyError(classInfo.getName(), importedPkg, comment));
        }
        return errors;
    }

    private static List<DependencyError> checkAlwaysForbiddenSection(Dependencies dependencies, ClassInfo classInfo) {
        ArrayList<DependencyError> errors = new ArrayList<DependencyError>();
        for (String importedPackage : classInfo.getImports()) {
            NotDependsOn ndo = Utils.findForbiddenByName(dependencies.getAlwaysForbidden(), importedPackage);
            if (ndo == null) continue;
            errors.add(new DependencyError(classInfo.getName(), importedPackage, ndo.getComment()));
        }
        return errors;
    }

    public final void analyze(File classesDir) {
        FileProcessor fileProcessor = new FileProcessor(new FileHandler(){

            public final FileHandlerResult handleFile(File classFile) {
                if (!classFile.getName().endsWith(".class")) {
                    return FileHandlerResult.CONTINUE;
                }
                try {
                    ClassInfo classInfo = new ClassInfo(classFile);
                    Package<DependsOn> allowedPkg = DependencyAnalyzer.this.dependencies.findAllowedByName(classInfo.getPackageName());
                    if (allowedPkg == null) {
                        Package<NotDependsOn> forbiddenPkg = DependencyAnalyzer.this.dependencies.findForbiddenByName(classInfo.getPackageName());
                        if (forbiddenPkg == null) {
                            DependencyAnalyzer.this.dependencyErrors.addAll(DependencyAnalyzer.checkAlwaysForbiddenSection(DependencyAnalyzer.this.dependencies, classInfo));
                        } else {
                            DependencyAnalyzer.this.dependencyErrors.addAll(DependencyAnalyzer.checkForbiddenSection(DependencyAnalyzer.this.dependencies, forbiddenPkg, classInfo));
                        }
                    } else {
                        DependencyAnalyzer.this.dependencyErrors.addAll(DependencyAnalyzer.this.checkAllowedSection(DependencyAnalyzer.this.dependencies, allowedPkg, classInfo));
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException("Error handling file: " + classFile, ex);
                }
                return FileHandlerResult.CONTINUE;
            }
        });
        this.dependencyErrors.clear();
        fileProcessor.process(classesDir);
    }

    public final List<DependencyError> getDependencyErrors() {
        return this.dependencyErrors;
    }

    public final Dependencies getDependencies() {
        return this.dependencies;
    }

    private static class ClassInfo {
        private final String packageName;
        private final String simpleName;
        private final Set<String> imports;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClassInfo(File classFile) throws IOException {
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(classFile));){
                DependencyVisitor visitor = new DependencyVisitor();
                new ClassReader((InputStream)in).accept((ClassVisitor)visitor, 0);
                Map<String, Map<String, Integer>> globals = visitor.getGlobals();
                Set<String> jarPackages = globals.keySet();
                this.packageName = jarPackages.iterator().next().replace('/', '.');
                this.simpleName = ClassInfo.nameOnly(classFile.getName());
                this.imports = new HashSet<String>();
                Iterator<String> it = visitor.getPackages().iterator();
                while (it.hasNext()) {
                    this.imports.add(it.next().replace('/', '.'));
                }
            }
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public final Set<String> getImports() {
            return this.imports;
        }

        public final String getName() {
            return this.packageName + "." + this.simpleName;
        }

        private static String nameOnly(String filename) {
            int p = filename.lastIndexOf(46);
            if (p == -1) {
                return filename;
            }
            return filename.substring(0, p);
        }
    }
}

